/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class Equal<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    protected String expectedValue;
    private Converter converter;

    public Equal(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Class typeOnPath = this.path(root).getJavaType();
        return cb.equal(this.path(root), this.converter.convert(this.expectedValue, typeOnPath));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        result = 31 * result + (this.expectedValue == null ? 0 : this.expectedValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Equal equal = (Equal)o;
        return Objects.equals(this.expectedValue, equal.expectedValue) && Objects.equals(this.converter, equal.converter);
    }

    public String toString() {
        return "Equal [expectedValue=" + this.expectedValue + ", converter=" + String.valueOf(this.converter) + ", path=" + this.path + "]";
    }
}

