/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategyAware;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.CaseConversionHelper;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class InIgnoreCase<T>
extends PathSpecification<T>
implements IgnoreCaseStrategyAware,
LocaleAware {
    private static final long serialVersionUID = 1L;
    protected String[] allowedValues;
    protected Converter converter;
    protected IgnoreCaseStrategy ignoreCaseStrategy;
    protected Locale locale;

    public InIgnoreCase(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length < 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected at least 1 but was " + Arrays.toString(httpParamValues));
        }
        this.allowedValues = httpParamValues;
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Path path = this.path(root);
        Class typeOnPath = path.getJavaType();
        if (typeOnPath.equals(String.class)) {
            CaseConversionHelper.ConvertedExpressionsList converted = CaseConversionHelper.applyCaseConversion(cb, this.path(root), this.allowedValues, this.ignoreCaseStrategy, this.locale);
            CriteriaBuilder.In inExpression = cb.in(converted.column());
            converted.values().forEach(arg_0 -> ((CriteriaBuilder.In)inExpression).value(arg_0));
            return inExpression;
        }
        return path.in(this.converter.convert(Arrays.asList(this.allowedValues), typeOnPath, true));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{Arrays.hashCode(this.allowedValues), this.converter, this.ignoreCaseStrategy, this.locale});
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InIgnoreCase other = (InIgnoreCase)o;
        return Arrays.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.converter, other.converter) && Objects.equals((Object)this.ignoreCaseStrategy, (Object)other.ignoreCaseStrategy) && Objects.equals(this.locale, other.locale);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[allowedValues=" + Arrays.toString(this.allowedValues) + ", converter=" + String.valueOf(this.converter) + ", path='" + this.path + "', ignoreCaseStrategy=" + String.valueOf((Object)this.ignoreCaseStrategy) + ", locale=" + String.valueOf(this.locale) + "]";
    }

    @Override
    public void setIgnoreCaseStrategy(IgnoreCaseStrategy ignoreCaseStrategy) {
        this.ignoreCaseStrategy = ignoreCaseStrategy;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

