/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class IsNotMember<T>
extends PathSpecification<T> {
    private String unwantedMember;
    private Converter converter;

    public IsNotMember(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.unwantedMember = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        Class typeOnPath = this.path(root).getModel().getBindableJavaType();
        Object convertedUnwantedMember = this.converter.convert(this.unwantedMember, typeOnPath);
        return criteriaBuilder.isNotMember(convertedUnwantedMember, this.path(root));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IsNotMember isNotMember = (IsNotMember)o;
        return Objects.equals(this.unwantedMember, isNotMember.unwantedMember) && Objects.equals(this.converter, isNotMember.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.unwantedMember, this.converter);
    }

    public String toString() {
        return "IsNotMember[unwantedMember='" + this.unwantedMember + "', converter=" + String.valueOf(this.converter) + ", path='" + this.path + "']";
    }
}

