/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategyAware;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.CaseConversionHelper;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotEqualIgnoreCase<T>
extends PathSpecification<T>
implements IgnoreCaseStrategyAware,
LocaleAware {
    private static final long serialVersionUID = 2L;
    protected String expectedValue;
    private Converter converter;
    private IgnoreCaseStrategy ignoreCaseStrategy;
    private Locale locale;

    public NotEqualIgnoreCase(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (this.path(root).getJavaType().equals(String.class)) {
            CaseConversionHelper.ConvertedExpressions converted = CaseConversionHelper.applyCaseConversion(cb, this.path(root), this.expectedValue, this.ignoreCaseStrategy, this.locale);
            return cb.notEqual(converted.column(), converted.value());
        }
        Class typeOnPath = this.path(root).getJavaType();
        return cb.notEqual(this.path(root), this.converter.convert(this.expectedValue, typeOnPath, true));
    }

    @Override
    public void setIgnoreCaseStrategy(IgnoreCaseStrategy ignoreCaseStrategy) {
        this.ignoreCaseStrategy = ignoreCaseStrategy;
    }

    @Override
    @Deprecated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.converter, this.expectedValue, this.ignoreCaseStrategy, this.locale});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotEqualIgnoreCase other = (NotEqualIgnoreCase)obj;
        return Objects.equals(this.converter, other.converter) && Objects.equals(this.expectedValue, other.expectedValue) && Objects.equals((Object)this.ignoreCaseStrategy, (Object)other.ignoreCaseStrategy) && Objects.equals(this.locale, other.locale);
    }

    public String toString() {
        return "NotEqualIgnoreCase[expectedValue='" + this.expectedValue + "', converter=" + String.valueOf(this.converter) + ", path='" + this.path + "', ignoreCaseStrategy=" + String.valueOf((Object)this.ignoreCaseStrategy) + ", locale=" + String.valueOf(this.locale) + "]";
    }
}

