/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategyAware;
import net.kaczmarzyk.spring.data.jpa.domain.InIgnoreCase;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotInIgnoreCase<T>
extends InIgnoreCase<T>
implements IgnoreCaseStrategyAware,
LocaleAware {
    private static final long serialVersionUID = 1L;

    public NotInIgnoreCase(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path, httpParamValues, converter);
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Predicate inIgnoreCasePredicate = super.toPredicate(root, query, cb);
        if (inIgnoreCasePredicate != null) {
            return inIgnoreCasePredicate.not();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotInIgnoreCase other = (NotInIgnoreCase)o;
        return Arrays.equals(this.allowedValues, other.allowedValues) && Objects.equals(this.converter, other.converter) && Objects.equals((Object)this.ignoreCaseStrategy, (Object)other.ignoreCaseStrategy) && Objects.equals(this.locale, other.locale);
    }
}

