/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.swagger.springdoc;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kaczmarzyk.spring.data.jpa.swagger.SpecExtractorUtil;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public class SpecificationArgResolverSpringdocOperationCustomizer
implements OperationCustomizer {
    private static final Schema<String> STRING_PARAMETER_SCHEMA = new StringSchema();
    private static final String JSON_FILTER_PARAMETER_NAME = "filterRequestBody";

    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        if (Objects.isNull(operation) || Objects.isNull(handlerMethod)) {
            return operation;
        }
        List<String> requiredParams = this.extractRequiredParametersFromHandlerMethod(handlerMethod, RequestMapping::params);
        List<String> requiredHeaders = this.extractRequiredParametersFromHandlerMethod(handlerMethod, RequestMapping::headers);
        Arrays.stream(handlerMethod.getMethodParameters()).map(this::extractAnnotationsFromMethodParameter).map(SpecExtractorUtil::extractNestedSpecificationsFromAnnotations).map(specs -> this.createParametersFromSpecs((List<Spec>)specs, requiredParams, requiredHeaders)).flatMap(Collection::stream).distinct().forEach(parameter -> this.addOrUpdateParameter(operation, (Parameter)parameter));
        return operation;
    }

    private void addOrUpdateParameter(Operation operation, Parameter parameter) {
        if (Objects.nonNull(operation.getParameters())) {
            operation.getParameters().removeIf(operationParameter -> this.parametersRepresentTheSameProperty((Parameter)operationParameter, parameter));
        }
        operation.addParametersItem(parameter);
    }

    private boolean parametersRepresentTheSameProperty(Parameter firstParameter, Parameter secondParameter) {
        return Objects.equals(firstParameter.getName(), secondParameter.getName()) && Objects.equals(firstParameter.getIn(), secondParameter.getIn());
    }

    private List<String> extractRequiredParametersFromHandlerMethod(HandlerMethod handlerMethod, Function<RequestMapping, String[]> parametersFetchingFunction) {
        return Optional.ofNullable((RequestMapping)handlerMethod.getMethodAnnotation(RequestMapping.class)).map(parametersFetchingFunction).map(Arrays::asList).orElse(Collections.emptyList());
    }

    private List<Annotation> extractAnnotationsFromMethodParameter(MethodParameter methodParameter) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(methodParameter.getParameterAnnotations()));
        this.extractAnnotationsRecursive(annotations, methodParameter.getParameterType());
        return annotations;
    }

    private void extractAnnotationsRecursive(List<Annotation> buffer, Class<?> clazz) {
        if (clazz != Specification.class) {
            List<Annotation> innerParameterAnnotations = Arrays.asList(clazz.getAnnotations());
            buffer.addAll(innerParameterAnnotations);
            for (Class<?> extendedInterface : clazz.getInterfaces()) {
                this.extractAnnotationsRecursive(buffer, extendedInterface);
            }
        }
    }

    private List<Parameter> createParametersFromSpecs(List<Spec> specs, List<String> requiredParams, List<String> requiredHeaders) {
        List<Parameter> parameters = specs.stream().map(spec -> {
            ArrayList<Parameter> specParameters = new ArrayList<Parameter>();
            specParameters.addAll(this.createParameters(spec.params(), requiredParams, ParameterIn.QUERY));
            specParameters.addAll(this.createParameters(spec.pathVars(), Collections.emptyList(), ParameterIn.PATH));
            specParameters.addAll(this.createParameters(spec.headers(), requiredHeaders, ParameterIn.HEADER));
            return specParameters;
        }).flatMap(Collection::stream).collect(Collectors.toList());
        this.createJsonPathsParameterFromSpecs(specs).ifPresent(parameters::add);
        return parameters;
    }

    private List<Parameter> createParameters(String[] parameters, List<String> requiredParameters, ParameterIn parameterIn) {
        return Arrays.stream(parameters).map(parameterName -> {
            Parameter specParam = this.generateParameterFromParameterIn(parameterIn);
            specParam.setName(parameterName);
            specParam.setRequired(Boolean.valueOf(requiredParameters.contains(parameterName) || parameterIn == ParameterIn.PATH));
            specParam.setSchema(STRING_PARAMETER_SCHEMA);
            return specParam;
        }).collect(Collectors.toList());
    }

    private Optional<Parameter> createJsonPathsParameterFromSpecs(List<Spec> specs) {
        List<String> jsonPaths = specs.stream().map(Spec::jsonPaths).flatMap(Arrays::stream).collect(Collectors.toList());
        if (jsonPaths.isEmpty()) {
            return Optional.empty();
        }
        Parameter jsonParameter = this.generateParameterFromParameterIn(ParameterIn.QUERY);
        jsonParameter.setName(JSON_FILTER_PARAMETER_NAME);
        Map<String, Schema> schemasForJsonPaths = this.preparePropertiesMapFromJsonPaths(jsonPaths);
        ObjectSchema parameterSchema = new ObjectSchema();
        parameterSchema.setProperties(schemasForJsonPaths);
        jsonParameter.setSchema((Schema)parameterSchema);
        jsonParameter.setRequired(Boolean.valueOf(false));
        return Optional.of(jsonParameter);
    }

    private Map<String, Schema> preparePropertiesMapFromJsonPaths(List<String> jsonPaths) {
        HashMap<String, Schema> ejectedPaths = new HashMap<String, Schema>();
        jsonPaths.forEach(jsonPath -> {
            String[] partsOfJsonPath = jsonPath.split("\\.");
            Iterator jsonPathIterator = Arrays.stream(partsOfJsonPath).iterator();
            String firstPartOfPath = (String)jsonPathIterator.next();
            if (!ejectedPaths.containsKey(firstPartOfPath)) {
                ObjectSchema jsonSchema = jsonPathIterator.hasNext() ? new ObjectSchema() : STRING_PARAMETER_SCHEMA;
                ejectedPaths.put(firstPartOfPath, (Schema)jsonSchema);
            }
            Schema previousSchema = (Schema)ejectedPaths.get(firstPartOfPath);
            while (jsonPathIterator.hasNext()) {
                String nextJsonPath = (String)jsonPathIterator.next();
                if (this.schemaDoesNotContainParameter(previousSchema, nextJsonPath)) {
                    ObjectSchema jsonSchema = jsonPathIterator.hasNext() ? new ObjectSchema() : STRING_PARAMETER_SCHEMA;
                    previousSchema.addProperty(nextJsonPath, (Schema)jsonSchema);
                }
                previousSchema = (Schema)previousSchema.getProperties().get(nextJsonPath);
            }
        });
        return ejectedPaths;
    }

    private boolean schemaDoesNotContainParameter(Schema<?> schema, String parameterName) {
        return Objects.isNull(schema.getProperties()) || !schema.getProperties().containsKey(parameterName);
    }

    private Parameter generateParameterFromParameterIn(ParameterIn parameterIn) {
        if (parameterIn == ParameterIn.PATH) {
            return new PathParameter();
        }
        if (parameterIn == ParameterIn.HEADER) {
            return new HeaderParameter();
        }
        return new QueryParameter();
    }

    static {
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(new Class[]{Specification.class});
    }
}

