/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;

public class CaseConversionHelper {
    public static ConvertedExpressions applyCaseConversion(CriteriaBuilder cb, Expression<String> columnExpression, String value, IgnoreCaseStrategy strategy, Locale locale) {
        IgnoreCaseStrategy effectiveStrategy;
        IgnoreCaseStrategy ignoreCaseStrategy = effectiveStrategy = strategy != null ? strategy : IgnoreCaseStrategy.DATABASE_UPPER;
        if (effectiveStrategy == IgnoreCaseStrategy.APPLICATION) {
            Locale effectiveLocale = locale != null ? locale : Locale.getDefault();
            String convertedValue = value.toUpperCase(effectiveLocale);
            return new ConvertedExpressions((Expression<String>)cb.upper(columnExpression), (Expression<String>)cb.literal((Object)convertedValue));
        }
        return new ConvertedExpressions(CaseConversionHelper.applyDatabaseCaseConversion(cb, columnExpression, effectiveStrategy), CaseConversionHelper.applyDatabaseCaseConversion(cb, (Expression<String>)cb.literal((Object)value), effectiveStrategy));
    }

    public static ConvertedExpressionsList applyCaseConversion(CriteriaBuilder cb, Expression<String> columnExpression, String[] values, IgnoreCaseStrategy strategy, Locale locale) {
        IgnoreCaseStrategy effectiveStrategy;
        IgnoreCaseStrategy ignoreCaseStrategy = effectiveStrategy = strategy != null ? strategy : IgnoreCaseStrategy.DATABASE_UPPER;
        if (effectiveStrategy == IgnoreCaseStrategy.APPLICATION) {
            Locale effectiveLocale = locale != null ? locale : Locale.getDefault();
            List<Expression<String>> convertedValues = Arrays.stream(values).map(value -> cb.literal((Object)value.toUpperCase(effectiveLocale))).toList();
            return new ConvertedExpressionsList((Expression<String>)cb.upper(columnExpression), convertedValues);
        }
        return new ConvertedExpressionsList(CaseConversionHelper.applyDatabaseCaseConversion(cb, columnExpression, effectiveStrategy), Arrays.stream(values).map(value -> CaseConversionHelper.applyDatabaseCaseConversion(cb, (Expression<String>)cb.literal(value), effectiveStrategy)).toList());
    }

    private static Expression<String> applyDatabaseCaseConversion(CriteriaBuilder cb, Expression<String> expression, IgnoreCaseStrategy strategy) {
        IgnoreCaseStrategy effectiveStrategy = strategy != null ? strategy : IgnoreCaseStrategy.DATABASE_UPPER;
        return switch (effectiveStrategy) {
            case IgnoreCaseStrategy.DATABASE_UPPER -> cb.upper(expression);
            case IgnoreCaseStrategy.DATABASE_LOWER -> cb.lower(expression);
            default -> throw new IllegalArgumentException("Unknown case strategy: " + String.valueOf((Object)effectiveStrategy));
        };
    }

    public record ConvertedExpressions(Expression<String> column, Expression<String> value) {
        public ConvertedExpressions {
            if (column == null) {
                throw new IllegalArgumentException("Column expression must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Value expression must not be null");
            }
        }
    }

    public record ConvertedExpressionsList(Expression<String> column, List<Expression<String>> values) {
        public ConvertedExpressionsList {
            if (column == null) {
                throw new IllegalArgumentException("Column expression must not be null");
            }
            if (values == null || values.isEmpty()) {
                throw new IllegalArgumentException("Values list must not be null or empty");
            }
            if (values.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("Values list must not contain null elements");
            }
        }
    }
}

