/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.OnTypeMismatch;
import org.springframework.core.convert.ConversionService;

public final class Converter {
    private static Map<Class<?>, String> DEFAULT_DATE_FORMATS = new HashMap();
    private static BiFunction<Enum<?>, String, Boolean> enumMatcherCaseSensitive;
    private BiFunction<Enum<?>, String, Boolean> enumMatcherCaseInsensitive;
    private String dateFormat;
    private OnTypeMismatch onTypeMismatch;
    private ConversionService conversionService;

    private Converter(String dateFormat, OnTypeMismatch onTypeMismatch, ConversionService conversionService, Locale locale) {
        this.dateFormat = dateFormat;
        this.onTypeMismatch = onTypeMismatch;
        this.conversionService = conversionService;
        this.enumMatcherCaseInsensitive = (enumVal, rawValue) -> enumVal.name().toUpperCase(locale).equals(rawValue.toUpperCase(locale));
    }

    public <T> List<T> convert(List<String> values, Class<T> expectedClass) {
        return this.convert(values, expectedClass, false);
    }

    public <T> List<T> convert(List<String> values, Class<T> expectedClass, boolean ignoreCase) {
        if (expectedClass == String.class) {
            return values;
        }
        ArrayList<String> rejected = null;
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values) {
            try {
                result.add(this.convert(value, expectedClass, ignoreCase));
            }
            catch (ValueRejectedException e) {
                if (rejected == null) {
                    rejected = new ArrayList<String>();
                }
                rejected.add(e.getRejectedValue());
            }
        }
        this.onTypeMismatch.handleRejectedValues(rejected);
        return result;
    }

    public <T> T convert(String value, Class<T> expectedClass) {
        return this.convert(value, expectedClass, false);
    }

    public <T> T convert(String value, Class<T> expectedClass, boolean ignoreCase) {
        if (expectedClass.isEnum()) {
            return this.convertToEnum(value, expectedClass, ignoreCase);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Boolean.class, Boolean.TYPE)) {
            return (T)this.convertToBoolean(value, ignoreCase);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Integer.class, Integer.TYPE, Long.class, Long.TYPE)) {
            return (T)this.convertToLong(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Float.TYPE, Float.class)) {
            return (T)this.convertToFloat(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Double.TYPE, Double.class)) {
            return (T)this.convertToDouble(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Character.TYPE, Character.class)) {
            return (T)this.convertToChar(value, ignoreCase);
        }
        if (expectedClass.isAssignableFrom(LocalDateTime.class)) {
            return (T)this.convertToLocalDateTime(value);
        }
        if (expectedClass.isAssignableFrom(LocalDate.class)) {
            return (T)this.convertToLocalDate(value);
        }
        if (expectedClass.isAssignableFrom(BigDecimal.class)) {
            return (T)this.convertToBigDecimal(value);
        }
        if (expectedClass.isAssignableFrom(UUID.class)) {
            return (T)this.convertToUUID(value);
        }
        if (expectedClass.isAssignableFrom(OffsetDateTime.class)) {
            return (T)this.convertToOffsetDateTime(value);
        }
        if (expectedClass.isAssignableFrom(Instant.class)) {
            return (T)this.convertToInstant(value);
        }
        if (expectedClass.isAssignableFrom(Timestamp.class)) {
            return (T)this.convertToTimestamp(value);
        }
        if (Objects.nonNull(this.conversionService) && this.conversionService.canConvert(String.class, expectedClass)) {
            return (T)this.conversionService.convert((Object)value, expectedClass);
        }
        return (T)value;
    }

    private boolean isAssignableFromAnyOf(Class<?> expectedClass, Class<?> ... candidates) {
        for (Class<?> candidate : candidates) {
            if (!expectedClass.isAssignableFrom(candidate)) continue;
            return true;
        }
        return false;
    }

    private LocalDate convertToLocalDate(String value) {
        String dateFormat = this.getDateFormat(LocalDate.class);
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
            return LocalDate.parse(value, formatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new ValueRejectedException(value, "LocalDate format exception, expected format: " + dateFormat, e);
        }
    }

    private LocalDateTime convertToLocalDateTime(String value) {
        String dateFormat = this.getDateFormat(LocalDateTime.class);
        try {
            DateTimeFormatter formatter = this.formatterWithDefaultTime(dateFormat);
            return LocalDateTime.parse(value, formatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new ValueRejectedException(value, "LocalDateTime format exception, expected format: " + dateFormat, e);
        }
    }

    private Long convertToLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception", e);
        }
    }

    private Double convertToDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception", e);
        }
    }

    private Character convertToChar(String value, boolean ignoreCase) {
        if (value.length() == 1) {
            return Character.valueOf(ignoreCase ? Character.toUpperCase(value.charAt(0)) : value.charAt(0));
        }
        throw new ValueRejectedException(value, "value is not a single character exception");
    }

    private Float convertToFloat(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception", e);
        }
    }

    private BigDecimal convertToBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception", e);
        }
    }

    private Boolean convertToBoolean(String value, boolean ignoreCase) {
        String valueToParse;
        String string = valueToParse = ignoreCase ? value.toLowerCase() : value;
        if ("true".equals(valueToParse)) {
            return true;
        }
        if ("false".equals(valueToParse)) {
            return false;
        }
        throw new ValueRejectedException(value, "unparseable boolean");
    }

    public String getDateFormat(Class<?> clazz) {
        if (this.dateFormat == null) {
            return DEFAULT_DATE_FORMATS.get(clazz);
        }
        return this.dateFormat;
    }

    public UUID convertToUUID(String value) {
        try {
            return UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new ValueRejectedException(value, "unparseable uuid", e);
        }
    }

    public OffsetDateTime convertToOffsetDateTime(String value) {
        String dateFormat = this.getDateFormat(OffsetDateTime.class);
        try {
            DateTimeFormatter formatter = this.formatterWithDefaultTime(dateFormat);
            return OffsetDateTime.parse(value, formatter);
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new ValueRejectedException(value, "OffsetDateTime format exception, expected format: " + dateFormat, e);
        }
    }

    public Instant convertToInstant(String value) {
        String dateFormat = this.getDateFormat(Instant.class);
        try {
            return Instant.from(this.formatterWithDefaultTime(dateFormat).parse(value));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new ValueRejectedException(value, "Instant format exception, expected format: " + dateFormat, e);
        }
    }

    private <T> T convertToEnum(String value, Class<? extends Enum<?>> enumClass, Boolean ignoreCase) {
        BiFunction<Enum<?>, String, Boolean> enumMatcher = ignoreCase != false ? this.enumMatcherCaseInsensitive : enumMatcherCaseSensitive;
        for (Enum<?> enumVal : enumClass.getEnumConstants()) {
            if (!enumMatcher.apply(enumVal, value).booleanValue()) continue;
            return (T)enumVal;
        }
        throw new ValueRejectedException(value, "could not find value " + value + " for enum class " + enumClass.getSimpleName());
    }

    private Timestamp convertToTimestamp(String value) {
        String dateFormat = this.getDateFormat(Timestamp.class);
        try {
            this.validateDateFormat(dateFormat, value);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            Date parsedDate = simpleDateFormat.parse(value);
            return new Timestamp(parsedDate.getTime());
        }
        catch (Exception e) {
            throw new ValueRejectedException(value, "Timestamp format exception, expected format: " + dateFormat, e);
        }
    }

    private void validateDateFormat(String expectedDateFormatPattern, String date) throws DateTimeParseException {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(expectedDateFormatPattern).withResolverStyle(ResolverStyle.STRICT);
        dateFormatter.parse(date);
    }

    private DateTimeFormatter formatterWithDefaultTime(String dateFormat) {
        return new DateTimeFormatterBuilder().appendPattern(dateFormat).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + (this.onTypeMismatch == null ? 0 : this.onTypeMismatch.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Converter converter = (Converter)o;
        return Objects.equals(this.dateFormat, converter.dateFormat) && this.onTypeMismatch == converter.onTypeMismatch;
    }

    public String toString() {
        return "Converter [dateFormat=" + this.dateFormat + ", onTypeMismatch=" + String.valueOf((Object)this.onTypeMismatch) + "]";
    }

    public static Converter withDateFormat(String dateFormat, OnTypeMismatch onTypeMismatch, ConversionService conversionService) {
        return new Converter(dateFormat, onTypeMismatch, conversionService, Locale.getDefault());
    }

    public static Converter withTypeMismatchBehaviour(OnTypeMismatch onTypeMismatch, ConversionService conversionService, Locale locale) {
        return new Converter(null, onTypeMismatch, conversionService, locale);
    }

    static {
        DEFAULT_DATE_FORMATS.put(Date.class, "yyyy-MM-dd");
        DEFAULT_DATE_FORMATS.put(LocalDate.class, "yyyy-MM-dd");
        DEFAULT_DATE_FORMATS.put(LocalDateTime.class, "yyyy-MM-dd'T'HH:mm:ss");
        DEFAULT_DATE_FORMATS.put(OffsetDateTime.class, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        DEFAULT_DATE_FORMATS.put(Instant.class, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        DEFAULT_DATE_FORMATS.put(Timestamp.class, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        enumMatcherCaseSensitive = (enumVal, rawValue) -> enumVal.name().equals(rawValue);
    }

    public static class ValueRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private String rejectedValue;

        public ValueRejectedException(String rejectedValue, String message) {
            this(rejectedValue, message, null);
        }

        public ValueRejectedException(String rejectedValue, String message, Exception cause) {
            super(message, cause);
            this.rejectedValue = rejectedValue;
        }

        public String getRejectedValue() {
            return this.rejectedValue;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getMessage();
        }
    }

    public static class ValuesRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private Collection<String> rejectedValues;

        public ValuesRejectedException(Collection<String> rejectedValues, String message) {
            super(message);
            this.rejectedValues = rejectedValues;
        }

        public Collection<String> getRejectedValues() {
            return this.rejectedValues;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass()) + ": " + this.getMessage();
        }
    }
}

