/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.kaczmarzyk.spring.data.jpa.utils.Alias;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class DefaultQueryContext
implements QueryContext {
    private Map<Alias, Function<Root<?>, Join<?, ?>>> contextMap = new HashMap();
    private Map<String, Fetch<?, ?>> evaluatedJoinFetch = new HashMap();
    private Map<Alias, Join<?, ?>> rootCache = new HashMap();

    @Override
    public boolean existsJoin(String key, Root<?> root) {
        return this.contextMap.containsKey(Alias.of(key, root));
    }

    @Override
    public Join<?, ?> getEvaluated(String key, Root<?> root) {
        Function<Root<?>, Join<?, ?>> value = this.contextMap.get(Alias.of(key, root));
        if (value == null) {
            return null;
        }
        Alias rootKey = Alias.of(key, root);
        if (!this.rootCache.containsKey(rootKey)) {
            Join<?, ?> evaluated = value.apply(root);
            this.rootCache.put(rootKey, evaluated);
        }
        return this.rootCache.get(rootKey);
    }

    @Override
    public void putLazyVal(Alias key, Function<Root<?>, Join<?, ?>> value) {
        this.contextMap.put(key, value);
    }

    @Override
    public Fetch<?, ?> getEvaluatedJoinFetch(String key) {
        return this.evaluatedJoinFetch.get(key);
    }

    @Override
    public void putEvaluatedJoinFetch(String key, Fetch<?, ?> fetch) {
        this.evaluatedJoinFetch.put(key, fetch);
    }

    public int hashCode() {
        int result = this.contextMap.hashCode();
        result = 31 * result + this.evaluatedJoinFetch.hashCode();
        result = 31 * result + this.rootCache.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultQueryContext that = (DefaultQueryContext)o;
        return Objects.equals(this.contextMap, that.contextMap) && Objects.equals(this.evaluatedJoinFetch, that.evaluatedJoinFetch) && Objects.equals(this.rootCache, that.rootCache);
    }

    public String toString() {
        return "DefaultQueryContext[contextMap=" + String.valueOf(this.contextMap) + "]";
    }
}

