/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.data.jpa.domain.Specification;

abstract class EnhancerUtil {
    EnhancerUtil() {
    }

    static <T> T wrapWithIfaceImplementation(Class<T> iface, Specification<Object> targetSpec) {
        return (T)Proxy.newProxyInstance(EnhancerUtil.class.getClassLoader(), new Class[]{iface}, (proxy, method, args) -> switch (method.getName()) {
            case "toPredicate" -> targetSpec.toPredicate((Root)args[0], (CriteriaQuery)args[1], (CriteriaBuilder)args[2]);
            case "toString" -> iface.getSimpleName() + "[" + targetSpec.toString() + "]";
            case "equals" -> EnhancerUtil.equals(iface, targetSpec, args);
            case "hashCode" -> targetSpec.hashCode();
            default -> targetSpec.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)targetSpec, args);
        });
    }

    private static boolean equals(Class<?> iface, Specification<Object> targetSpec, Object[] args) {
        if (args.length != 1 || args[0] == null) {
            return false;
        }
        if (!Proxy.isProxyClass(args[0].getClass())) {
            return false;
        }
        if (!EnhancerUtil.isAnObjectThatDirectImplementsGivenInterface(args[0], iface)) {
            return false;
        }
        return ReflectionUtils.get(Proxy.getInvocationHandler(args[0]), "arg$1").equals(targetSpec);
    }

    private static boolean isAnObjectThatDirectImplementsGivenInterface(Object object, Class<?> expectedType) {
        return EnhancerUtil.arrayContains(object.getClass().getInterfaces(), expectedType);
    }

    private static boolean arrayContains(Class<?>[] array, Class<?> valueToFind) {
        for (Class<?> arrayValue : array) {
            if (!arrayValue.equals(valueToFind)) continue;
            return true;
        }
        return false;
    }

    private static final class ReflectionUtils {
        private ReflectionUtils() {
        }

        static <T> T get(Object target, String fieldname) {
            try {
                Class<?> classToBeUsed = target.getClass();
                while (true) {
                    try {
                        Field f = classToBeUsed.getDeclaredField(fieldname);
                        f.setAccessible(true);
                        return (T)f.get(target);
                    }
                    catch (NoSuchFieldException err) {
                        classToBeUsed = classToBeUsed.getSuperclass();
                        if (classToBeUsed != Object.class) continue;
                        throw err;
                        if (classToBeUsed != Object.class) continue;
                        throw new NoSuchFieldException();
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

