/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.Locale;
import net.kaczmarzyk.spring.data.jpa.domain.IgnoreCaseStrategy;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationFactory;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestProcessingContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class SpecificationArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final IgnoreCaseStrategy DEFAULT_IGNORE_CASE_STRATEGY = IgnoreCaseStrategy.DATABASE_UPPER;
    private SpecificationFactory specificationFactory;

    public SpecificationArgumentResolver() {
        this(null, null, Locale.getDefault(), DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(ConversionService conversionService) {
        this(conversionService, null, Locale.getDefault(), DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(ConversionService conversionService, Locale defaultLocale) {
        this(conversionService, null, defaultLocale, DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(ConversionService conversionService, AbstractApplicationContext abstractApplicationContext) {
        this(conversionService, abstractApplicationContext, Locale.getDefault(), DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(Locale defaultLocale) {
        this(null, null, defaultLocale, DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(AbstractApplicationContext applicationContext) {
        this(null, applicationContext, Locale.getDefault(), DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(AbstractApplicationContext applicationContext, Locale defaultLocale) {
        this(null, applicationContext, defaultLocale, DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(ConversionService conversionService, AbstractApplicationContext abstractApplicationContext, Locale defaultLocale) {
        this(conversionService, abstractApplicationContext, defaultLocale, DEFAULT_IGNORE_CASE_STRATEGY);
    }

    public SpecificationArgumentResolver(IgnoreCaseStrategy ignoreCaseStrategy) {
        this(null, null, Locale.getDefault(), ignoreCaseStrategy);
    }

    public SpecificationArgumentResolver(ConversionService conversionService, IgnoreCaseStrategy ignoreCaseStrategy) {
        this(conversionService, null, Locale.getDefault(), ignoreCaseStrategy);
    }

    public SpecificationArgumentResolver(AbstractApplicationContext applicationContext, IgnoreCaseStrategy ignoreCaseStrategy) {
        this(null, applicationContext, Locale.getDefault(), ignoreCaseStrategy);
    }

    public SpecificationArgumentResolver(ConversionService conversionService, AbstractApplicationContext abstractApplicationContext, Locale defaultLocale, IgnoreCaseStrategy ignoreCaseStrategy) {
        IgnoreCaseStrategy effectiveStrategy = ignoreCaseStrategy != null ? ignoreCaseStrategy : DEFAULT_IGNORE_CASE_STRATEGY;
        this.specificationFactory = new SpecificationFactory(conversionService, abstractApplicationContext, defaultLocale, effectiveStrategy);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && this.isAnnotated(parameter);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        WebRequestProcessingContext context = new WebRequestProcessingContext(parameter, webRequest);
        return this.specificationFactory.createSpecificationDependingOn(context);
    }

    private boolean isAnnotated(MethodParameter methodParameter) {
        for (Annotation annotation : methodParameter.getParameterAnnotations()) {
            for (Class<? extends Annotation> annotationType : this.specificationFactory.getResolversBySupportedType()) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return true;
            }
        }
        return this.isAnnotatedRecursively(methodParameter.getParameterType());
    }

    private boolean isAnnotatedRecursively(Class<?> target) {
        if (target.getAnnotations().length != 0) {
            for (Class clazz : this.specificationFactory.getResolversBySupportedType()) {
                if (target.getAnnotation(clazz) == null) continue;
                return true;
            }
        }
        for (Class<?> targetInterface : target.getInterfaces()) {
            if (!this.isAnnotatedRecursively(targetInterface)) continue;
            return true;
        }
        return false;
    }
}

