package net.kafujo.samples.wikidata.parser;

import java.util.Objects;

public class IntParser extends WikidataParser<Integer> {

    public static final IntParser DEFAULT = new IntParser();

    @Override
    public Integer parseFbk(final String raw, Integer fbk) {
        try {
            return parse(raw);
        } catch (Exception any) {
            lgr.debug("could not get int from '{}': {}", raw, any.toString());
            fallbackCounter.merge(raw, 1, Integer::sum);
        }
        return fbk;
    }

    @Override
    public Integer parse(final String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse int");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse int");
        }
        String clean = raw.strip().replace(".", "").replace(",", "");
        return Integer.parseInt(clean);
    }
}
