package net.kafujo.samples.wikidata.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LongParser extends WikidataParser<Long>{

    public static final LongParser DEFAULT = new LongParser();

    @Override
    public Long parseFbk(final String raw, Long fbk) {
        try {
            return parse(raw);
        } catch (Exception any) {
            lgr.debug("could not get Long from '{}': {}", raw, any.toString());
            fallbackCounter.merge(raw, 1, Integer::sum);
        }
        return fbk;
    }

    @Override
    public Long parse(final String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse long");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse long");
        }
        String clean = raw.strip().replace(".", "").replace(",", "");
        return Long.parseLong(clean);
    }
}
