/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata.parser;

import java.util.Objects;
import net.kafujo.samples.wikidata.parser.WikidataParser;

public class IntParser
extends WikidataParser<Integer> {
    public static final IntParser DEFAULT = new IntParser();

    @Override
    public Integer parseFbk(String raw, Integer fbk) {
        try {
            return this.parse(raw);
        }
        catch (Exception any) {
            this.lgr.debug("could not get int from '{}': {}", (Object)raw, (Object)any.toString());
            this.fallbackCounter.merge(raw, 1, Integer::sum);
            return fbk;
        }
    }

    @Override
    public Integer parse(String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse int");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse int");
        }
        String clean = raw.strip().replace(".", "").replace(",", "");
        return Integer.parseInt(clean);
    }
}

