/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata.parser;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;
import net.kafujo.samples.wikidata.parser.WikidataParser;

public class LocalDateParser
extends WikidataParser<LocalDate> {
    public static final LocalDateParser DEFAULT = new LocalDateParser();

    @Override
    public LocalDate parseFbk(String raw, LocalDate fbk) {
        try {
            return this.parse(raw);
        }
        catch (Exception any) {
            this.lgr.debug("could not get LocalDate from '{}': {}", (Object)raw, (Object)any.toString());
            this.fallbackCounter.merge(raw, 1, Integer::sum);
            return fbk;
        }
    }

    @Override
    public LocalDate parse(String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse date");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse date");
        }
        String clean = raw.strip();
        return LocalDate.ofInstant(Instant.parse(clean), ZoneId.systemDefault());
    }
}

