/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.kafujo.base.UncheckedException;
import net.kafujo.samples.wikidata.parser.WikidataParser;

public class UrlParser
extends WikidataParser<URL> {
    public static final UrlParser DEFAULT = new UrlParser();

    @Override
    public URL parseFbk(String raw, URL fbk) {
        try {
            return this.parse(raw);
        }
        catch (Exception any) {
            this.lgr.debug("could not get URL from '{}': {}", (Object)raw, (Object)any.toString());
            this.fallbackCounter.merge(raw, 1, Integer::sum);
            return fbk;
        }
    }

    @Override
    public URL parse(String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse URL");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse URL");
        }
        String clean = raw.strip();
        try {
            return new URL(clean);
        }
        catch (MalformedURLException fail) {
            throw new UncheckedException("Problem parsing URL from " + clean, (Throwable)fail);
        }
    }
}

