/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import net.karneim.pojobuilder.analysis.Input;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzerUtil;
import net.karneim.pojobuilder.analysis.Output;
import net.karneim.pojobuilder.analysis.TypeMFactory;
import net.karneim.pojobuilder.model.FieldAccessM;
import net.karneim.pojobuilder.model.MethodM;
import net.karneim.pojobuilder.model.PropertyM;
import net.karneim.pojobuilder.model.SetterMethodM;
import net.karneim.pojobuilder.model.TypeM;

public class PojoPropertiesScanner {
    private final Elements elements;
    private final JavaModelAnalyzerUtil javaModelAnalyzerUtil;
    private final TypeMFactory typeMFactory;

    public PojoPropertiesScanner(Elements elements, JavaModelAnalyzerUtil javaModelAnalyzerUtil, TypeMFactory typeMFactory) {
        this.elements = elements;
        this.javaModelAnalyzerUtil = javaModelAnalyzerUtil;
        this.typeMFactory = typeMFactory;
    }

    public void scan(Input input, Output output) {
        this.scanFields(input, output);
        this.scanSetterMethods(input, output);
        this.scanGetterMethods(input, output);
    }

    private void scanSetterMethods(Input input, Output output) {
        TypeElement pojoTypeEl = input.getPojoElement();
        DeclaredType pojoClassType = (DeclaredType)pojoTypeEl.asType();
        List<? extends Element> memberEls = this.elements.getAllMembers(pojoTypeEl);
        List<ExecutableElement> methodEls = ElementFilter.methodsIn(memberEls);
        for (ExecutableElement methodEl : methodEls) {
            if (this.javaModelAnalyzerUtil.isStatic(methodEl) || !this.javaModelAnalyzerUtil.isSetterMethod(methodEl) || this.javaModelAnalyzerUtil.isDeclaredInObject(methodEl) || !this.javaModelAnalyzerUtil.isAccessibleForBuilder(methodEl, output.getBuilderModel())) continue;
            String propertyName = this.javaModelAnalyzerUtil.getPropertyName(methodEl);
            ExecutableType execType = (ExecutableType)this.javaModelAnalyzerUtil.getType(pojoClassType, methodEl);
            TypeMirror propertyTypeMirror = execType.getParameterTypes().get(0);
            TypeM propertyType = this.typeMFactory.getTypeM(propertyTypeMirror);
            output.getBuilderModel().getProperties().getOrCreate(propertyName, propertyType).writableVia(new SetterMethodM(methodEl.getSimpleName().toString(), methodEl.getModifiers()).withVarArgs(methodEl.isVarArgs()).declaredIn(this.typeMFactory.getTypeM(input.getPojoType())));
            output.getInput().getOrginatingElements().add(this.javaModelAnalyzerUtil.getCompilationUnit(methodEl));
        }
    }

    private void scanFields(Input input, Output output) {
        TypeElement pojoTypeEl = input.getPojoElement();
        List<? extends Element> memberEls = this.elements.getAllMembers(pojoTypeEl);
        List<VariableElement> fieldEls = ElementFilter.fieldsIn(memberEls);
        for (VariableElement fieldEl : fieldEls) {
            if (this.javaModelAnalyzerUtil.isStatic(fieldEl) || this.javaModelAnalyzerUtil.isDeclaredInObject(fieldEl) || !this.javaModelAnalyzerUtil.isAccessibleForBuilder(fieldEl, output.getBuilderModel())) continue;
            DeclaredType declType = (DeclaredType)pojoTypeEl.asType();
            TypeM propertyType = this.typeMFactory.getTypeM(this.javaModelAnalyzerUtil.getType(declType, fieldEl));
            output.getBuilderModel().getProperties().getOrCreate(fieldEl.getSimpleName().toString(), propertyType).accessibleVia(new FieldAccessM(fieldEl.getModifiers()).declaredIn(this.typeMFactory.getTypeM(input.getPojoType())));
            output.getInput().getOrginatingElements().add(this.javaModelAnalyzerUtil.getCompilationUnit(fieldEl));
        }
    }

    private void scanGetterMethods(Input input, Output output) {
        TypeElement pojoTypeEl = input.getPojoElement();
        DeclaredType pojoClassType = (DeclaredType)pojoTypeEl.asType();
        List<? extends Element> memberEls = this.elements.getAllMembers(pojoTypeEl);
        List<ExecutableElement> methodsEls = ElementFilter.methodsIn(memberEls);
        for (ExecutableElement methodEl : methodsEls) {
            if (this.javaModelAnalyzerUtil.isStatic(methodEl) || !this.javaModelAnalyzerUtil.isGetterMethod(methodEl) || this.javaModelAnalyzerUtil.isDeclaredInObject(methodEl) || !this.javaModelAnalyzerUtil.isAccessibleForBuilder(methodEl, output.getBuilderModel())) continue;
            String propertyName = this.javaModelAnalyzerUtil.getPropertyName(methodEl);
            ExecutableType execType = (ExecutableType)this.javaModelAnalyzerUtil.getType(pojoClassType, methodEl);
            TypeMirror propertyTypeMirror = execType.getReturnType();
            TypeM propertyType = this.typeMFactory.getTypeM(propertyTypeMirror);
            PropertyM prop = output.getBuilderModel().getProperties().get(propertyName, propertyType);
            if (prop != null) {
                prop.readableVia((MethodM)new MethodM(methodEl.getSimpleName().toString(), methodEl.getModifiers()).declaredIn(this.typeMFactory.getTypeM(input.getPojoType())));
            }
            output.getInput().getOrginatingElements().add(this.javaModelAnalyzerUtil.getCompilationUnit(methodEl));
        }
    }
}

