/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.karneim.pojobuilder.analysis.PropertyPattern;
import net.karneim.pojobuilder.model.ArgumentListM;
import net.karneim.pojobuilder.model.ArgumentM;
import net.karneim.pojobuilder.model.Positional;
import net.karneim.pojobuilder.model.PropertyM;
import net.karneim.pojobuilder.model.TypeListM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.model.WriteAccess;

public class PropertyListM
implements Iterable<PropertyM> {
    private LinkedHashMap<Key, PropertyM> elements = new LinkedHashMap();

    public PropertyListM(Iterable<PropertyM> other) {
        for (PropertyM t : other) {
            this.add(t);
        }
    }

    public PropertyListM(PropertyM ... elems) {
        this(Arrays.asList(elems));
    }

    @Override
    public Iterator<PropertyM> iterator() {
        return this.elements.values().iterator();
    }

    public PropertyM get(String propertyName, TypeM propertyType) {
        return this.get(new Key(propertyName, propertyType));
    }

    public PropertyM get(Key key) {
        return this.elements.get(key);
    }

    public PropertyM getOrCreate(String propertyName, TypeM propertyType) {
        PropertyM elem = this.elements.get(new Key(propertyName, propertyType));
        if (elem == null) {
            elem = new PropertyM(propertyName, propertyType);
            this.add(elem);
        }
        return elem;
    }

    public PropertyListM add(PropertyM prop) {
        Key key = this.keyOf(prop);
        if (this.elements.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Property with key %s already in list!", key));
        }
        this.elements.put(key, prop);
        return this;
    }

    private Key keyOf(PropertyM prop) {
        Key result = new Key(prop.getPropertyName(), prop.getPropertyType());
        return result;
    }

    public PropertyListM filterOutNonWritableProperties(TypeM accessingClass) {
        PropertyListM result = new PropertyListM(new PropertyM[0]);
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (p.isWritableBy(accessingClass)) continue;
            result.add(p);
            it.remove();
        }
        return result;
    }

    public PropertyListM filterOutPropertiesWritableBy(WriteAccess.Type type, TypeM accessingClass) {
        PropertyListM result = new PropertyListM(new PropertyM[0]);
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (p.getPreferredWriteAccessFor(accessingClass).getType() != type) continue;
            result.add(p);
            it.remove();
        }
        return result;
    }

    public ArgumentListM toArgumentList(WriteAccess.Type type, TypeM accessingClass) {
        ArgumentListM result = new ArgumentListM();
        for (PropertyM p : this) {
            WriteAccess writeAccess = p.getPreferredWriteAccessFor(accessingClass);
            if (writeAccess.getType() != type) continue;
            Positional positional = (Positional)((Object)writeAccess);
            int pos = positional.getPos();
            result.add(new ArgumentM(p, pos));
        }
        return result;
    }

    public ArgumentListM filterOutPropertiesWritableViaConstructorParameter(TypeM accessingClass) {
        ArgumentListM result = new ArgumentListM();
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (p.getPreferredWriteAccessFor(accessingClass).getType() != WriteAccess.Type.CONSTRUCTOR) continue;
            int pos = p.getConstructorParameter().getPos();
            result.add(new ArgumentM(p, pos));
            it.remove();
        }
        return result;
    }

    public ArgumentListM filterOutPropertiesWritableViaFactoryMethodParameter(TypeM accessingClass) {
        ArgumentListM result = new ArgumentListM();
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (p.getPreferredWriteAccessFor(accessingClass).getType() != WriteAccess.Type.FACTORY) continue;
            int pos = p.getFactoryMethodParameter().getPos();
            result.add(new ArgumentM(p, pos));
            it.remove();
        }
        return result;
    }

    public PropertyListM filterOutPropertiesReadableViaGetterCall(TypeM accessingClass) {
        PropertyListM result = new PropertyListM(new PropertyM[0]);
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (!p.isReadableViaGetterMethodBy(accessingClass)) continue;
            result.add(p);
            it.remove();
        }
        return result;
    }

    public PropertyListM filterOutPropertiesReadableViaFieldAccess(TypeM accessingClass) {
        PropertyListM result = new PropertyListM(new PropertyM[0]);
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (!p.isReadableViaFieldAccessBy(accessingClass)) continue;
            result.add(p);
            it.remove();
        }
        return result;
    }

    public PropertyListM filterOutPropertiesReadableBy(TypeM accessingClass) {
        PropertyListM result = new PropertyListM(new PropertyM[0]);
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (!p.isReadableViaFieldAccessBy(accessingClass) && !p.isReadableViaGetterMethodBy(accessingClass)) continue;
            result.add(p);
            it.remove();
        }
        return result;
    }

    public void retainPropertiesMatchingAnyOf(List<PropertyPattern> list) {
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (p.matchesAnyOf(list) || p.isWritableViaConstructor() || p.isWritableViaFactoryMethod()) continue;
            it.remove();
        }
    }

    public void removePropertiesMatchingAnyOf(List<PropertyPattern> list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator<PropertyM> it = this.iterator();
        while (it.hasNext()) {
            PropertyM p = it.next();
            if (!p.matchesAnyOf(list) || p.isWritableViaConstructor() || p.isWritableViaFactoryMethod()) continue;
            it.remove();
        }
    }

    public boolean hasPropertiesReadablyBy(TypeM accessingClass) {
        return !new PropertyListM(this).filterOutPropertiesReadableBy(accessingClass).isEmpty();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public TypeListM getTypes() {
        TypeListM result = new TypeListM(new TypeM[0]);
        for (PropertyM p : this) {
            result.add(p.getPropertyType());
        }
        return result;
    }

    public String toString() {
        return "PropertyListM [elements=" + this.elements + "]";
    }

    public static class Key {
        String propertyName;
        String propertyType;

        public Key(String propertyName, TypeM propertyType) {
            this(propertyName, propertyType.getName());
        }

        public Key(String propertyName, String propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public String toString() {
            return "Key [propertyName=" + this.propertyName + ", propertyType=" + this.propertyType + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            result = 31 * result + (this.propertyType == null ? 0 : this.propertyType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
                return false;
            }
            return !(this.propertyType == null ? other.propertyType != null : !this.propertyType.equals(other.propertyType));
        }
    }
}

