/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import net.karneim.pojobuilder.model.BuilderM;

public class JavaModelAnalyzerUtil {
    private static final String BUILD_METHOD_NAME = "build";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private final Elements elements;
    private final Types types;

    public JavaModelAnalyzerUtil(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
    }

    public PrimitiveType getPrimitiveBooleanType() {
        return this.types.getPrimitiveType(TypeKind.BOOLEAN);
    }

    public NoType getVoidType() {
        return this.types.getNoType(TypeKind.VOID);
    }

    public String getClassname(TypeElement typeElem) {
        String qualifiedName = typeElem.getQualifiedName().toString();
        String packageName = this.getPackage(typeElem);
        if (packageName.isEmpty()) {
            return qualifiedName;
        }
        String result = qualifiedName.substring(packageName.length() + 1);
        return result;
    }

    public String getPackage(DeclaredType type) {
        return this.getPackage((TypeElement)type.asElement());
    }

    public String getPackage(TypeElement typeElem) {
        Element outerElem = typeElem.getEnclosingElement();
        while (!(outerElem instanceof PackageElement)) {
            outerElem = outerElem.getEnclosingElement();
        }
        PackageElement packEl = (PackageElement)outerElem;
        return packEl.getQualifiedName().toString();
    }

    public TypeElement getCompilationUnit(Element elem) {
        if (elem instanceof TypeElement && elem.getEnclosingElement() instanceof PackageElement) {
            return (TypeElement)elem;
        }
        return this.getCompilationUnit(elem.getEnclosingElement());
    }

    public boolean isAccessibleForBuilder(Element el, BuilderM builderM) {
        if (el.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        PackageElement fieldPackage = this.elements.getPackageOf(el);
        String builderPackge = builderM.getType().getPackageName();
        if (fieldPackage.isUnnamed()) {
            return builderPackge == null;
        }
        return fieldPackage.getQualifiedName().toString().equals(builderPackge);
    }

    public boolean isStatic(Element el) {
        return el.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isSetterMethod(ExecutableElement el) {
        String methodName = el.getSimpleName().toString();
        return methodName.startsWith(SET) && methodName.length() > SET.length() && el.getParameters().size() == 1;
    }

    public boolean isGetterMethod(ExecutableElement el) {
        String methodName = el.getSimpleName().toString();
        TypeMirror retType = el.getReturnType();
        return (methodName.startsWith(GET) && methodName.length() > GET.length() || methodName.startsWith(IS) && methodName.length() > IS.length()) && retType.getKind() != TypeKind.VOID && el.getParameters().size() == 0;
    }

    public boolean isDeclaredInObject(Element el) {
        Element ownerEl = el.getEnclosingElement();
        if (ownerEl.getKind() == ElementKind.CLASS) {
            TypeElement typeEl = (TypeElement)ownerEl;
            return typeEl.getQualifiedName().toString().equals(Object.class.getName());
        }
        return false;
    }

    public String getPropertyName(ExecutableElement methodEl) {
        String name = methodEl.getSimpleName().toString();
        int prefixLength = -1;
        if (name.startsWith(SET)) {
            prefixLength = SET.length();
        } else if (name.startsWith(GET)) {
            prefixLength = GET.length();
        } else if (name.startsWith(IS)) {
            prefixLength = IS.length();
        }
        if (prefixLength > 0) {
            name = name.substring(prefixLength);
            name = this.firstCharToLowerCase(name);
            return name;
        }
        throw new IllegalArgumentException(String.format("Not a setter or getter method name: %s!", name));
    }

    private String firstCharToLowerCase(String text) {
        char[] vals = text.toCharArray();
        vals[0] = Character.toLowerCase(vals[0]);
        return String.valueOf(vals);
    }

    public TypeMirror getType(DeclaredType ownerType, Element element) {
        TypeMirror execType = element.asType();
        try {
            execType = this.types.asMemberOf(ownerType, element);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return execType;
    }

    public boolean hasBuildMethod(TypeElement typeElement, TypeMirror requiredReturnType) {
        return this.hasMethod(typeElement, BUILD_METHOD_NAME, requiredReturnType, null);
    }

    public boolean hasMethod(TypeElement typeElement, String name, TypeMirror requiredReturnType, TypeMirror requiredParamType) {
        List<? extends Element> memberEls = this.elements.getAllMembers(typeElement);
        List<ExecutableElement> methodEls = ElementFilter.methodsIn(memberEls);
        for (ExecutableElement methodEl : methodEls) {
            String actualName = methodEl.getSimpleName().toString();
            if (!actualName.equals(name)) continue;
            TypeMirror actualReturnType = methodEl.getReturnType();
            if (actualReturnType.getKind() == TypeKind.TYPEVAR) {
                TypeVariable tv = (TypeVariable)actualReturnType;
                actualReturnType = tv.getUpperBound();
            }
            if (requiredReturnType != null && !this.types.isSubtype(requiredReturnType, actualReturnType) || requiredParamType == null && methodEl.getParameters().size() > 0) continue;
            if (requiredParamType != null) {
                if (methodEl.getParameters().size() != 1) continue;
                TypeMirror actParamType = methodEl.getParameters().get(0).asType();
                if (actParamType.getKind() == TypeKind.TYPEVAR) {
                    TypeVariable tv = (TypeVariable)actualReturnType;
                    actParamType = tv.getUpperBound();
                }
                if (!this.types.isSubtype(requiredParamType, actParamType)) continue;
            }
            return true;
        }
        return false;
    }

    public boolean hasPublicNoArgsConstructor(TypeElement typeEl) {
        List<? extends Element> memberEls = this.elements.getAllMembers(typeEl);
        List<ExecutableElement> constrEls = ElementFilter.constructorsIn(memberEls);
        for (ExecutableElement constrEl : constrEls) {
            if (!constrEl.getModifiers().contains((Object)Modifier.PUBLIC) || !constrEl.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean matchesUpperBound(TypeElement typeElement, TypeParameterElement typeParamEl) {
        TypeMirror typeParam = typeParamEl.asType();
        if (typeParam.getKind() != TypeKind.TYPEVAR) {
            throw new RuntimeException(String.format("Unexpected kind of type parameter for %s: %s", new Object[]{typeParamEl.getSimpleName(), typeParam.getKind()}));
        }
        TypeVariable tv = (TypeVariable)typeParam;
        return this.types.isSubtype(typeElement.asType(), tv.getUpperBound());
    }

    public boolean isUpperBoundToObject(TypeParameterElement typeParamEl) {
        TypeMirror typeParam = typeParamEl.asType();
        if (typeParam.getKind() != TypeKind.TYPEVAR) {
            throw new RuntimeException(String.format("Unexpected kind of type parameter for %s: %s", new Object[]{typeParamEl.getSimpleName(), typeParam.getKind()}));
        }
        TypeVariable tv = (TypeVariable)typeParam;
        TypeElement objectElem = this.elements.getTypeElement(Object.class.getName());
        return this.types.isSameType(objectElem.asType(), tv.getUpperBound());
    }

    public boolean isValidJavaIdentifier(String string) {
        char[] chars = string.toCharArray();
        if (chars.length > 0 && !Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isValidJavaPackageName(String string) {
        String[] parts;
        for (String part : parts = string.split("\\.")) {
            if (this.isValidJavaIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    public Collection<? extends Element> findAnnotatedElements(Collection<TypeElement> typeElements, Class<?> annotationType) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : typeElements) {
            this.findAnnotatedElements(result, element, annotationType);
        }
        return result;
    }

    private void findAnnotatedElements(List<Element> result, Element element, Class<?> annotationType) {
        switch (element.getKind()) {
            case CLASS: {
                TypeElement typeEl = (TypeElement)element;
                for (AnnotationMirror annotationMirror : typeEl.getAnnotationMirrors()) {
                    if (!annotationType.getName().equals(this.getName(annotationMirror))) continue;
                    result.add(typeEl);
                }
                List<? extends Element> enclosedElems = typeEl.getEnclosedElements();
                for (Element element2 : enclosedElems) {
                    this.findAnnotatedElements(result, element2, annotationType);
                }
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElement executableElement = (ExecutableElement)element;
                for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                    if (!annotationType.getName().equals(this.getName(annotationMirror))) continue;
                    result.add(executableElement);
                }
                break;
            }
        }
    }

    private String getName(AnnotationMirror anno) {
        TypeElement el = (TypeElement)anno.getAnnotationType().asElement();
        return el.getQualifiedName().toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(firstChar)).append(str.substring(1)).toString();
    }
}

