/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import net.karneim.pojobuilder.analysis.JavaModelAnalyzerUtil;
import net.karneim.pojobuilder.analysis.UnresolvedTypeException;
import net.karneim.pojobuilder.model.ArrayTypeM;
import net.karneim.pojobuilder.model.PrimitiveTypeM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.model.TypeVariableM;
import net.karneim.pojobuilder.model.TypeWildcardM;

public class TypeMFactory {
    private final JavaModelAnalyzerUtil javaModelAnalyzerUtil;
    private final Map<TypeParameterElement, TypeVariableM> typeVarCache = new HashMap<TypeParameterElement, TypeVariableM>();

    public TypeMFactory(JavaModelAnalyzerUtil javaModelAnalyzerUtil) {
        this.javaModelAnalyzerUtil = javaModelAnalyzerUtil;
    }

    public TypeM getTypeM(TypeElement typeElem) {
        String packageName = this.javaModelAnalyzerUtil.getPackage(typeElem);
        String classname = this.javaModelAnalyzerUtil.getClassname(typeElem);
        TypeM result = new TypeM(packageName, classname).withTypeParameter(this.getTypeMArray(typeElem.getTypeParameters()));
        return result;
    }

    public TypeM getTypeM(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        switch (kind) {
            case BOOLEAN: {
                return PrimitiveTypeM.BOOLEAN;
            }
            case CHAR: {
                return PrimitiveTypeM.CHAR;
            }
            case BYTE: {
                return PrimitiveTypeM.BYTE;
            }
            case SHORT: {
                return PrimitiveTypeM.SHORT;
            }
            case INT: {
                return PrimitiveTypeM.INT;
            }
            case LONG: {
                return PrimitiveTypeM.LONG;
            }
            case FLOAT: {
                return PrimitiveTypeM.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveTypeM.DOUBLE;
            }
            case DECLARED: {
                DeclaredType dt = (DeclaredType)typeMirror;
                return this.getTypeM(dt);
            }
            case VOID: {
                return PrimitiveTypeM.VOID;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                return new ArrayTypeM(this.getTypeM(arrayType.getComponentType()));
            }
            case TYPEVAR: {
                if (typeMirror instanceof TypeVariable) {
                    TypeVariable typeVar = (TypeVariable)typeMirror;
                    return this.getTypeVariableM((TypeParameterElement)typeVar.asElement());
                }
                throw new UnresolvedTypeException(String.format("Expected TypeVariable for %s (%s)", typeMirror, typeMirror.getClass().getName()));
            }
            case ERROR: {
                String message = String.format("%s could not be resolved! Possibly this class is not compiled, not imported, or not part of the classpath.", typeMirror);
                throw new IllegalArgumentException(message);
            }
        }
        throw new UnsupportedOperationException(String.format("Unexpected kind %s for typeMirror %s", new Object[]{kind, typeMirror.getClass().getName()}));
    }

    public TypeM getTypeM(DeclaredType type) {
        TypeElement typeElem = (TypeElement)type.asElement();
        String packageName = this.javaModelAnalyzerUtil.getPackage(typeElem);
        String classname = this.javaModelAnalyzerUtil.getClassname(typeElem);
        TypeM result = new TypeM(packageName, classname);
        if (!type.getTypeArguments().isEmpty()) {
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                TypeMirror superBound;
                if (typeMirror.getKind() == TypeKind.DECLARED) {
                    TypeM typeArgElemTypeM = this.getTypeM(typeMirror);
                    result.withTypeParameter(typeArgElemTypeM);
                    continue;
                }
                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                    TypeVariable typeVar = (TypeVariable)typeMirror;
                    TypeParameterElement typeParamElem = (TypeParameterElement)typeVar.asElement();
                    TypeVariableM var = this.getTypeVariableM(typeParamElem);
                    result.withTypeParameter(var);
                    continue;
                }
                if (typeMirror.getKind() != TypeKind.WILDCARD) continue;
                TypeMirror extendsBound = ((WildcardType)typeMirror).getExtendsBound();
                TypeWildcardM wildcard = new TypeWildcardM();
                if (extendsBound != null) {
                    TypeM bound = this.getTypeM(extendsBound);
                    wildcard.whichExtends(bound);
                }
                if ((superBound = ((WildcardType)typeMirror).getSuperBound()) != null) {
                    TypeM bound = this.getTypeM(superBound);
                    wildcard.whichIsASupertypeOf(bound);
                }
                result.withTypeParameter(wildcard);
            }
        }
        return result;
    }

    public TypeM[] getTypeMArray(List<? extends TypeParameterElement> typeParams) {
        if (typeParams == null) {
            return new TypeM[0];
        }
        TypeM[] result = new TypeM[typeParams.size()];
        for (int i = 0; i < result.length; ++i) {
            TypeParameterElement typeParameterElement = typeParams.get(i);
            TypeVariableM var = this.getTypeVariableM(typeParameterElement);
            result[i] = var;
        }
        return result;
    }

    private TypeVariableM getTypeVariableM(TypeParameterElement typeParameterElement) {
        TypeVariableM var = this.typeVarCache.get(typeParameterElement);
        if (var == null) {
            var = new TypeVariableM(typeParameterElement.getSimpleName().toString());
            this.typeVarCache.put(typeParameterElement, var);
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            for (TypeMirror typeMirror : bounds) {
                if (this.isJavaLangObject(typeMirror)) continue;
                TypeM typeM = this.getTypeM(typeMirror);
                var.whichExtends(typeM);
            }
        }
        return var;
    }

    private boolean isJavaLangObject(TypeMirror bound) {
        if (bound.getKind() == TypeKind.DECLARED) {
            TypeElement typeElem = (TypeElement)((DeclaredType)bound).asElement();
            String packageName = this.javaModelAnalyzerUtil.getPackage(typeElem);
            String classname = this.javaModelAnalyzerUtil.getClassname(typeElem);
            return "java.lang.Object".equals(packageName + "." + classname);
        }
        return false;
    }
}

