/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeM;

public class ArrayTypeM
extends TypeM {
    private final TypeM componentType;

    public ArrayTypeM(TypeM componentType) {
        super(ArrayTypeM.getName(componentType));
        this.componentType = componentType;
    }

    private static String getName(TypeM componentType) {
        return componentType.getName() + "[]";
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public String getGenericTypeDefinition() {
        return this.componentType.getGenericTypeDefinition() + "[]";
    }

    @Override
    public String getGenericType() {
        return this.componentType.getGenericType() + "[]";
    }

    public String getGenericTypeDeclarationAsVarArgs() {
        return this.componentType.getGenericType() + "...";
    }

    @Override
    public ImportTypesM addToImportTypes(ImportTypesM result) {
        this.componentType.addToImportTypes(result);
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.componentType == null ? 0 : this.componentType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayTypeM other = (ArrayTypeM)obj;
        return !(this.componentType == null ? other.componentType != null : !this.componentType.equals(other.componentType));
    }

    @Override
    public String toString() {
        return "ArrayTypeM [componentType=" + this.componentType + ", getGenericTypeDefinition()=" + this.getGenericTypeDefinition() + "]";
    }
}

