/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeListM;
import net.karneim.pojobuilder.model.TypeM;

public class TypeVariableM
extends TypeM {
    protected final TypeListM bounds = new TypeListM(new TypeM[0]);

    public TypeVariableM(String name) {
        super(name);
    }

    @Override
    public boolean isTypeVariable() {
        return true;
    }

    public TypeVariableM whichExtends(TypeM ... types) {
        for (TypeM bound : types) {
            this.bounds.add(bound);
        }
        return this;
    }

    public boolean hasBounds() {
        return !this.bounds.isEmpty();
    }

    public String getBoundsString() {
        StringBuilder result = new StringBuilder();
        for (TypeM bound : this.bounds) {
            if (result.length() > 0) {
                result.append(" & ");
            }
            result.append(bound.getGenericType());
        }
        return result.toString();
    }

    @Override
    public String getGenericTypeDefinition() {
        if (!this.hasBounds()) {
            return this.getName();
        }
        return String.format("%s %s %s", this.getName(), this.getBoundRelation(), this.getBoundsString());
    }

    protected String getBoundRelation() {
        return "extends";
    }

    @Override
    public ImportTypesM addToImportTypes(ImportTypesM result) {
        if (result.add(this)) {
            this.bounds.addToImportTypes(result);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeVariableM other = (TypeVariableM)obj;
        return !(this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds));
    }

    @Override
    public String toString() {
        return "TypeVariableM [getGenericTypeDefinition()=" + this.getGenericTypeDefinition() + "]";
    }
}

