/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.sourcegen;

import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.util.EnumSet;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.ManualBuilderM;
import net.karneim.pojobuilder.model.StaticFactoryMethodM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.sourcegen.BuilderSourceGenerator;

public class ManualBuilderSourceGenerator {
    private JavaWriter writer;

    public ManualBuilderSourceGenerator(JavaWriter writer) {
        this.writer = writer;
    }

    public void generateSource(ManualBuilderM builder) throws IOException {
        this.generateSource(builder.getType(), builder.getBaseType(), builder.getPojoType(), builder.getStaticFactoryMethod());
    }

    private void generateSource(TypeM builderType, TypeM baseType, TypeM pojoType, StaticFactoryMethodM staticFactoryMethod) throws IOException {
        this.writer.emitPackage(builderType.getPackageName());
        ImportTypesM importTypes = pojoType.addToImportTypes(new ImportTypesM());
        importTypes.add(Generated.class);
        baseType.addToImportTypes(importTypes);
        importTypes.removePackage(builderType.getPackageName());
        importTypes.removePackage("java.lang");
        String builderTypeName = this.writer.compressType(builderType.getName());
        String pojoTypeName = this.writer.compressType(pojoType.getName());
        this.writer.emitImports(importTypes.getSortedDistinctClassnames()).emitEmptyLine().emitJavadoc("The {@link %s} is a Builder for {@link %s} objects.\n<p> ATTENTION:\n    This class has been generated.\n    If you want to ADD HANDWRITTEN CODE,\n    please MOVE THIS FILE out of the generated-sources folder\n    in order to prevent it from being overwritten by the\n    PojoBuilder generator!\n</p>\n", new Object[]{builderTypeName, pojoTypeName}).emitAnnotation(Generated.class, (Object)JavaWriter.stringLiteral((String)"PojoBuilder")).beginType(builderType.getGenericTypeDefinition(), "class", EnumSet.of(Modifier.PUBLIC), baseType.getGenericType(), new String[0]);
        if (staticFactoryMethod != null) {
            BuilderSourceGenerator.emitStaticFactoryMethod(builderType, staticFactoryMethod, this.writer);
        }
        this.writer.emitEmptyLine().emitJavadoc("Creates a new {@link %s}.", new Object[]{builderTypeName}).beginConstructor(EnumSet.of(Modifier.PUBLIC), new String[0]).endConstructor();
        this.writer.endType();
    }
}

