/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.sourcegen;

import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import net.karneim.pojobuilder.GwtIncompatible;
import net.karneim.pojobuilder.Visibility;
import net.karneim.pojobuilder.model.ArgumentListM;
import net.karneim.pojobuilder.model.ArrayTypeM;
import net.karneim.pojobuilder.model.BuildMethodM;
import net.karneim.pojobuilder.model.BuilderM;
import net.karneim.pojobuilder.model.CloneMethodM;
import net.karneim.pojobuilder.model.CopyMethodM;
import net.karneim.pojobuilder.model.FactoryMethodM;
import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.OptionalM;
import net.karneim.pojobuilder.model.PrimitiveTypeM;
import net.karneim.pojobuilder.model.PropertyListM;
import net.karneim.pojobuilder.model.PropertyM;
import net.karneim.pojobuilder.model.StaticFactoryMethodM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.model.ValidatorM;
import net.karneim.pojobuilder.model.WriteAccess;
import net.karneim.pojobuilder.sourcegen.Defaults;

public class BuilderSourceGenerator {
    private JavaWriter writer;
    private TypeM generatedAnnotationType;
    private List<String> warnings = new ArrayList<String>();

    public BuilderSourceGenerator(JavaWriter writer, TypeM generatedAnnotationType) {
        this.writer = writer;
        this.generatedAnnotationType = generatedAnnotationType;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    private void addWarning(String messageFormat, Object ... args) {
        this.warnings.add(String.format(messageFormat, args));
    }

    public void generateSource(BuilderM builder) throws IOException {
        this.checkNotNull(builder.getPojoType(), "builder.getPojoType() must not be null");
        this.checkNotNull(builder.getType(), "builder.getBuilderType() must not be null");
        this.checkNotNull(builder.getProperties(), "builder.getProperties() must not be null");
        this.generateSource(builder.getType(), builder.isAbstract(), builder.getSelfType(), builder.getBaseType(), builder.getInterfaceType(), builder.hasBuilderProperties(), builder.getPojoType(), builder.getProperties(), builder.getBuildMethod(), builder.getFactoryMethod(), builder.getCopyMethod(), builder.getValidator(), builder.getOptional(), builder.getStaticFactoryMethod(), builder.getConstructorVisibility(), builder.getCloneMethod());
    }

    private void checkNotNull(Object obj, String errorMessage) {
        if (obj == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    private void generateSource(TypeM builderType, boolean isAbstract, TypeM selfType, TypeM baseType, TypeM interfaceType, boolean hasBuilderProperties, TypeM pojoType, PropertyListM properties, BuildMethodM buildMethod, FactoryMethodM factoryMethod, CopyMethodM copyMethodM, ValidatorM validator, OptionalM optional, StaticFactoryMethodM staticFactoryMethod, Visibility constructorVisibility, CloneMethodM cloneMethod) throws IOException {
        String[] interfaces;
        String baseclass;
        properties = new PropertyListM(properties);
        properties.filterOutNonWritableProperties(builderType);
        ImportTypesM importTypes = pojoType.addToImportTypes(new ImportTypesM());
        if (factoryMethod != null) {
            factoryMethod.getDeclaringClass().addToImportTypes(importTypes);
        }
        properties.getTypes().addToImportTypes(importTypes);
        importTypes.add(GwtIncompatible.class);
        if (optional != null) {
            optional.getType().addToImportTypes(importTypes);
        }
        if (baseType == null || baseType.getName().equals("java.lang.Object")) {
            baseclass = null;
        } else {
            baseclass = baseType.getGenericType();
            baseType.addToImportTypes(importTypes);
        }
        EnumSet<Modifier> builderTypeModifier = isAbstract ? EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT) : EnumSet.of(Modifier.PUBLIC);
        if (interfaceType == null) {
            interfaces = new String[]{"Cloneable"};
        } else {
            interfaces = new String[]{interfaceType.getGenericType(), "Cloneable"};
            interfaceType.addToImportTypes(importTypes);
        }
        if (validator != null) {
            validator.getType().addToImportTypes(importTypes);
        }
        this.generatedAnnotationType.addToImportTypes(importTypes);
        importTypes.removePackage(builderType.getPackageName());
        importTypes.removePackage("java.lang");
        this.writer.emitPackage(builderType.getPackageName()).emitImports(importTypes.getSortedDistinctClassnames()).emitEmptyLine().emitAnnotation(this.generatedAnnotationType.getName(), (Object)JavaWriter.stringLiteral((String)"PojoBuilder")).beginType(builderType.getGenericTypeDefinition(), "class", builderTypeModifier, baseclass, interfaces).emitField(selfType.getGenericType(), "self", EnumSet.of(Modifier.PROTECTED));
        if (validator != null) {
            this.emitValidatorField(validator);
        }
        for (PropertyM prop : properties) {
            this.emitPropertyFields(prop, interfaceType, hasBuilderProperties, optional);
        }
        if (staticFactoryMethod != null) {
            BuilderSourceGenerator.emitStaticFactoryMethod(selfType, staticFactoryMethod, this.writer);
        }
        this.emitConstructor(builderType, selfType, constructorVisibility);
        for (PropertyM prop : properties) {
            this.emitWithMethod(builderType, selfType, pojoType, prop, optional);
            if (optional != null) {
                this.emitWithOptionalMethod(builderType, selfType, pojoType, prop, optional);
            }
            if (interfaceType == null || !hasBuilderProperties) continue;
            this.emitWithMethodUsingBuilderInterface(builderType, selfType, interfaceType, pojoType, prop, optional);
        }
        this.emitCloneMethod(selfType, cloneMethod);
        this.emitButMethod(selfType);
        if (copyMethodM != null) {
            if (properties.hasPropertiesReadablyBy(builderType)) {
                this.emitCopyMethod(builderType, selfType, pojoType, properties, copyMethodM);
            } else {
                this.addWarning("[PojoBuilder] Skipping the generation of %s method because none of the writable properties are readable!", copyMethodM.getName());
            }
        }
        this.emitBuildMethod(builderType, pojoType, interfaceType, hasBuilderProperties, optional, properties, factoryMethod, buildMethod, validator);
        this.writer.endType();
    }

    private void emitValidatorField(ValidatorM validator) throws IOException {
        String validatorTypeDeclaration = this.writer.compressType(validator.getType().getGenericType());
        String initialization = String.format("new %s()", validatorTypeDeclaration);
        this.writer.emitField(validatorTypeDeclaration, validator.getFieldName(), EnumSet.of(Modifier.PROTECTED), initialization);
    }

    static void emitStaticFactoryMethod(TypeM selfType, StaticFactoryMethodM method, JavaWriter writer) throws IOException {
        String returnTypeDecl;
        String builderTypeDeclaration = writer.compressType(selfType.getGenericType());
        if (selfType.isGeneric()) {
            String typeParameters = "<" + writer.compressType(selfType.getTypeParameters().toParameterString()) + ">";
            returnTypeDecl = typeParameters + " " + builderTypeDeclaration;
        } else {
            returnTypeDecl = builderTypeDeclaration;
        }
        writer.emitEmptyLine().emitJavadoc("Factory Method to construct a %s\n\n@return a new %s", new Object[]{builderTypeDeclaration, builderTypeDeclaration}).beginMethod(returnTypeDecl, method.getName(), method.getModifiers(), new String[0]).emitStatement("return new %s()", new Object[]{builderTypeDeclaration}).endMethod();
    }

    private void emitCopyMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyListM properties, CopyMethodM copyMethodM) throws IOException {
        properties = new PropertyListM(properties);
        String selfTypeDeclaration = this.writer.compressType(selfType.getGenericType());
        String pojoTypeDeclaration = this.writer.compressType(pojoType.getGenericType());
        this.writer.emitEmptyLine().emitJavadoc("Copies the values from the given pojo into this builder.\n\n@param pojo\n@return this builder", new Object[0]).beginMethod(selfTypeDeclaration, copyMethodM.getName(), EnumSet.of(Modifier.PUBLIC), new String[]{pojoTypeDeclaration, "pojo"});
        PropertyListM getterProperties = properties.filterOutPropertiesReadableViaGetterCall(builderType);
        for (PropertyM prop : getterProperties) {
            String withMethodName = prop.getWithMethodName();
            this.writer.emitStatement("%s(pojo.%s())", new Object[]{withMethodName, prop.getGetterMethod().getName()});
        }
        PropertyListM readableFieldProperties = properties.filterOutPropertiesReadableViaFieldAccess(builderType);
        for (PropertyM prop : readableFieldProperties) {
            String withMethodName = prop.getWithMethodName();
            this.writer.emitStatement("%s(pojo.%s)", new Object[]{withMethodName, prop.getPropertyName()});
        }
        this.writer.emitStatement("return self", new Object[0]);
        this.writer.endMethod();
    }

    private void emitBuildMethod(TypeM builderType, TypeM pojoType, TypeM interfaceType, boolean hasBuilderProperties, OptionalM optional, PropertyListM properties, FactoryMethodM factoryMethod, BuildMethodM buildMethod, ValidatorM validator) throws IOException {
        Object arguments;
        ArgumentListM argumentMs;
        properties = new PropertyListM(properties);
        String pojoTypeDeclaration = this.writer.compressType(pojoType.getGenericType());
        String pojoClassname = this.writer.compressType(pojoType.getName());
        this.writer.emitEmptyLine().emitJavadoc("Creates a new {@link %s} based on this builder's settings.\n\n@return the created %s", new Object[]{pojoClassname, pojoClassname});
        if (buildMethod.isOverrides()) {
            this.writer.emitAnnotation(Override.class);
        }
        this.writer.beginMethod(pojoTypeDeclaration, buildMethod.getName(), EnumSet.of(Modifier.PUBLIC), new String[0]).beginControlFlow("try", new Object[0]);
        if (!hasBuilderProperties && optional == null) {
            String arguments2;
            if (factoryMethod == null) {
                arguments2 = properties.filterOutPropertiesWritableViaConstructorParameter(builderType).toArgumentString();
                this.writer.emitStatement("%s result = new %s(%s)", new Object[]{pojoTypeDeclaration, pojoTypeDeclaration, arguments2});
            } else {
                arguments2 = properties.filterOutPropertiesWritableViaFactoryMethodParameter(builderType).toArgumentString();
                String factoryClass = this.writer.compressType(factoryMethod.getDeclaringClass().getName());
                this.writer.emitStatement("%s result = %s.%s(%s)", new Object[]{pojoTypeDeclaration, factoryClass, factoryMethod.getName(), arguments2});
            }
        } else if (factoryMethod == null) {
            argumentMs = properties.filterOutPropertiesWritableViaConstructorParameter(builderType);
            arguments = this.emitParameterAssignments(hasBuilderProperties, optional, buildMethod, argumentMs);
            this.writer.emitStatement("%s result = new %s(%s)", new Object[]{pojoTypeDeclaration, pojoTypeDeclaration, arguments});
        } else {
            argumentMs = properties.filterOutPropertiesWritableViaFactoryMethodParameter(builderType);
            arguments = this.emitParameterAssignments(hasBuilderProperties, optional, buildMethod, argumentMs);
            String factoryClass = this.writer.compressType(factoryMethod.getDeclaringClass().getName());
            this.writer.emitStatement("%s result = %s.%s(%s)", new Object[]{pojoTypeDeclaration, factoryClass, factoryMethod.getName(), arguments});
        }
        PropertyListM setterProperties = properties.filterOutPropertiesWritableBy(WriteAccess.Type.SETTER, builderType);
        for (PropertyM prop : setterProperties) {
            String setTemplate = "result." + prop.getSetterMethod().getName() + "(%s)";
            this.emitBuildPropertyStatement(hasBuilderProperties, buildMethod, optional, prop, setTemplate);
        }
        PropertyListM writableProperties = properties.filterOutPropertiesWritableBy(WriteAccess.Type.FIELD, builderType);
        for (PropertyM prop : writableProperties) {
            String setTemplate = "result." + prop.getPropertyName() + " = %s";
            this.emitBuildPropertyStatement(hasBuilderProperties, buildMethod, optional, prop, setTemplate);
        }
        if (validator != null) {
            this.writer.emitStatement("%s.%s(result)", new Object[]{validator.getFieldName(), validator.getMethodName()});
        }
        this.writer.emitStatement("return result", new Object[0]).nextControlFlow("catch (RuntimeException ex)", new Object[0]).emitStatement("throw ex", new Object[0]).nextControlFlow("catch (Exception ex)", new Object[0]).emitStatement("throw new RuntimeException(ex)", new Object[0]).endControlFlow().endMethod();
    }

    private String emitParameterAssignments(boolean hasBuilderProperties, OptionalM optional, BuildMethodM buildMethod, ArgumentListM factoryMethodArguments) throws IOException {
        StringBuilder arguments = new StringBuilder();
        for (PropertyM prop : factoryMethodArguments.sortByPosition().getPropertyList()) {
            String parameterFieldName = "_" + prop.getPropertyName();
            this.emitParameterAssignment(prop, parameterFieldName, optional, hasBuilderProperties, buildMethod);
            if (arguments.length() > 0) {
                arguments.append(", ");
            }
            arguments.append(parameterFieldName);
        }
        return arguments.toString();
    }

    private void emitBuildPropertyStatement(boolean hasBuilderProperties, BuildMethodM buildMethod, OptionalM optional, PropertyM prop, String setTemplate) throws IOException {
        TypeM type = prop.getPropertyType();
        String compressedType = this.writer.compressType(type.getGenericType());
        if (optional == null) {
            this.writer.beginControlFlow("if (%s)", new Object[]{prop.getIsSetFieldName()});
            this.writer.emitStatement(setTemplate, new Object[]{prop.getValueFieldName()});
        } else if (type.isPrimitive()) {
            this.writer.beginControlFlow("if (%s.isPresent())", new Object[]{prop.getValueFieldName()});
            this.writer.emitStatement(setTemplate, new Object[]{prop.getValueFieldName() + ".get()"});
        } else if (prop.isOptionalProperty(optional)) {
            this.writer.beginControlFlow("if (%s == null || %s.isPresent())", new Object[]{prop.getValueFieldName(), prop.getValueFieldName()});
            this.writer.emitStatement(setTemplate, new Object[]{prop.getValueFieldName()});
        } else {
            this.writer.beginControlFlow("if (%s == null)", new Object[]{prop.getValueFieldName()});
            this.writer.emitStatement(setTemplate, new Object[]{"(" + compressedType + ") null"});
            this.writer.nextControlFlow("else if (%s.isPresent())", new Object[]{prop.getValueFieldName()});
            this.writer.emitStatement(setTemplate, new Object[]{prop.getValueFieldName() + ".get()"});
        }
        if (hasBuilderProperties) {
            this.writer.nextControlFlow("else if (%s != null)", new Object[]{prop.getBuilderFieldName()});
            String callBuild = prop.getCallTo(buildMethod);
            if (optional == null || !prop.isOptionalProperty(optional)) {
                this.writer.emitStatement(setTemplate, new Object[]{callBuild});
            } else {
                String basicType = this.writer.compressType(prop.getBasicPropertyType(optional).getGenericType());
                String tempFieldName = "builtValue";
                this.writer.emitStatement("%s %s = %s", new Object[]{basicType, tempFieldName, callBuild});
                this.writer.beginControlFlow("if (%s == null)", new Object[]{tempFieldName});
                this.writer.emitStatement(setTemplate, new Object[]{"(" + compressedType + ") null"});
                this.writer.nextControlFlow("else", new Object[0]);
                this.writer.emitStatement(setTemplate, new Object[]{optional.of(tempFieldName)});
                this.writer.endControlFlow();
            }
        }
        this.writer.endControlFlow();
    }

    private void emitParameterAssignment(PropertyM prop, String parameterFieldName, OptionalM optional, boolean hasBuilderProperties, BuildMethodM buildMethod) throws IOException {
        TypeM propertyType = prop.getPropertyType();
        String compressedType = this.writer.compressType(propertyType.getGenericType());
        String builderFieldName = prop.getBuilderFieldName();
        String valueField = prop.getValueFieldName();
        String callBuild = prop.getCallTo(buildMethod);
        if (optional == null) {
            this.writer.emitStatement("%s %s", new Object[]{compressedType, parameterFieldName});
            this.writer.beginControlFlow("if (!%s && %s != null)", new Object[]{prop.getIsSetFieldName(), builderFieldName});
            this.writer.emitStatement("%s = %s", new Object[]{parameterFieldName, callBuild});
            this.writer.nextControlFlow("else", new Object[0]);
            this.writer.emitStatement("%s = %s", new Object[]{parameterFieldName, valueField});
            this.writer.endControlFlow();
        } else if (prop.isOptionalProperty(optional)) {
            this.writer.emitStatement("%s %s = %s", new Object[]{compressedType, parameterFieldName, valueField});
            if (hasBuilderProperties) {
                this.writer.beginControlFlow("if (%s != null && !%s.isPresent() && %s != null)", new Object[]{valueField, valueField, builderFieldName});
                String basicType = this.writer.compressType(prop.getBasicPropertyType(optional).getGenericType());
                String tempFieldName = "builtValue";
                this.writer.emitStatement("%s %s = %s", new Object[]{basicType, tempFieldName, callBuild});
                this.writer.beginControlFlow("if (%s != null)", new Object[]{tempFieldName});
                this.writer.emitStatement("%s = %s", new Object[]{parameterFieldName, optional.of(tempFieldName)});
                this.writer.endControlFlow();
                this.writer.endControlFlow();
            }
        } else {
            String defaultValue = "null";
            if (propertyType.isPrimitive()) {
                Class<?> type = ((PrimitiveTypeM)propertyType).getType();
                defaultValue = Defaults.defaultValueAsLiteral(type);
            }
            this.writer.emitStatement("%s %s = %s", new Object[]{compressedType, parameterFieldName, defaultValue});
            boolean extraControlFlow = false;
            if (propertyType.isPrimitive()) {
                this.writer.beginControlFlow("if (%s.isPresent())", new Object[]{valueField});
            } else if (hasBuilderProperties) {
                extraControlFlow = true;
                this.writer.beginControlFlow("if (%s != null)", new Object[]{valueField});
                this.writer.beginControlFlow("if (%s.isPresent())", new Object[]{valueField});
            } else {
                this.writer.beginControlFlow("if (%s != null && %s.isPresent())", new Object[]{valueField, valueField});
            }
            this.writer.emitStatement("%s = %s.get()", new Object[]{parameterFieldName, valueField});
            if (hasBuilderProperties) {
                this.writer.nextControlFlow("else if (%s != null)", new Object[]{builderFieldName});
                this.writer.emitStatement("%s = %s", new Object[]{parameterFieldName, callBuild});
            }
            if (extraControlFlow) {
                this.writer.endControlFlow();
            }
            this.writer.endControlFlow();
        }
    }

    private void emitWithMethodUsingBuilderInterface(TypeM builderType, TypeM selfType, TypeM interfaceType, TypeM pojoType, PropertyM prop, OptionalM optional) throws IOException {
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        String parameterTypeStr = prop.getParameterizedBuilderInterfaceType(interfaceType, optional).getGenericType();
        this.writer.emitEmptyLine();
        this.writer.emitJavadoc("Sets the default builder for the {@link %s#%s} property.\n\n@param builder the default builder\n@return this builder", new Object[]{pojoTypeStr, prop.getPropertyName()});
        this.writer.beginMethod(selfType.getGenericType(), withMethodName, EnumSet.of(Modifier.PUBLIC), new String[]{parameterTypeStr, "builder"});
        this.writer.emitStatement("this.%s = builder", new Object[]{prop.getBuilderFieldName()});
        if (optional == null) {
            this.writer.emitStatement("this.%s = false", new Object[]{prop.getIsSetFieldName()});
        } else {
            this.writer.emitStatement("this.%s = %s", new Object[]{prop.getValueFieldName(), optional.absent()});
        }
        this.writer.emitStatement("return self", new Object[0]).endMethod();
    }

    private void emitWithMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyM prop, OptionalM optional) throws IOException {
        String parameterTypeStr;
        String valueFieldName = prop.getValueFieldName();
        String isSetFieldName = prop.getIsSetFieldName();
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        TypeM propertyType = prop.getBasicPropertyType(optional);
        if (propertyType.isArrayType() && prop.getPreferredWriteAccessFor(builderType).isVarArgs()) {
            ArrayTypeM arrayType = (ArrayTypeM)propertyType;
            String paramTypeStr = arrayType.getGenericType();
            parameterTypeStr = this.writer.compressType(paramTypeStr);
            parameterTypeStr = parameterTypeStr.substring(0, parameterTypeStr.length() - 2).concat("...");
        } else {
            parameterTypeStr = propertyType.getGenericType();
        }
        this.writer.emitEmptyLine();
        this.writer.emitJavadoc("Sets the default value for the {@link %s#%s} property.\n\n@param value the default value\n@return this builder", new Object[]{pojoTypeStr, prop.getPropertyName()});
        this.writer.beginMethod(selfType.getGenericType(), withMethodName, EnumSet.of(Modifier.PUBLIC), new String[]{parameterTypeStr, "value"});
        if (optional == null) {
            this.writer.emitStatement("this.%s = value", new Object[]{valueFieldName});
            this.writer.emitStatement("this.%s = true", new Object[]{isSetFieldName});
        } else if (propertyType.isPrimitive()) {
            this.writer.emitStatement("this.%s = %s", new Object[]{valueFieldName, optional.of("value")});
        } else {
            this.writer.beginControlFlow("if (%s)", new Object[]{"value == null"}).emitStatement("this.%s = null", new Object[]{valueFieldName}).nextControlFlow("else", new Object[0]).emitStatement("this.%s = %s", new Object[]{valueFieldName, optional.of("value")}).endControlFlow();
        }
        this.writer.emitStatement("return self", new Object[0]).endMethod();
    }

    private void emitWithOptionalMethod(TypeM builderType, TypeM selfType, TypeM pojoType, PropertyM prop, OptionalM optional) throws IOException {
        String withMethodName = prop.getWithMethodName();
        String pojoTypeStr = this.writer.compressType(pojoType.getName());
        String optionalParameterTypeStr = prop.getOptionalPropertyType(optional).getGenericType();
        optionalParameterTypeStr = this.writer.compressType(optionalParameterTypeStr);
        this.writer.emitEmptyLine();
        this.writer.emitJavadoc("Optionally sets the default value for the {@link %s#%s} property.\n\n@param optionalValue the optional default value\n@return this builder", new Object[]{pojoTypeStr, prop.getPropertyName()});
        this.writer.beginMethod(selfType.getGenericType(), withMethodName, EnumSet.of(Modifier.PUBLIC), new String[]{optionalParameterTypeStr, "optionalValue"});
        String condition = prop.getPropertyType().isPrimitive() ? "optionalValue.isPresent()" : "optionalValue == null || optionalValue.isPresent()";
        this.writer.beginControlFlow("if (%s)", new Object[]{condition}).emitStatement("this.%s = optionalValue", new Object[]{prop.getValueFieldName()}).endControlFlow();
        this.writer.emitStatement("return self", new Object[0]).endMethod();
    }

    private void emitConstructor(TypeM builderType, TypeM selfType, Visibility visibility) throws IOException {
        String selfTypeStr = this.writer.compressType(selfType.getGenericType());
        String builderTypeName = this.writer.compressType(builderType.getName());
        Modifier modifier = visibility.asModifier();
        this.writer.emitEmptyLine().emitJavadoc("Creates a new {@link %s}.", new Object[]{builderTypeName}).beginConstructor(modifier == null ? EnumSet.noneOf(Modifier.class) : EnumSet.of(modifier), new String[0]).emitStatement("self = (%s)this", new Object[]{selfTypeStr}).endConstructor();
    }

    private void emitPropertyFields(PropertyM prop, TypeM interfaceType, boolean hasBuilderProperties, OptionalM optional) throws IOException {
        String valueFieldName = prop.getValueFieldName();
        if (optional == null) {
            String isSetFieldName = prop.getIsSetFieldName();
            this.writer.emitField(prop.getPropertyType().getGenericType(), valueFieldName, EnumSet.of(Modifier.PROTECTED));
            this.writer.emitField("boolean", isSetFieldName, EnumSet.of(Modifier.PROTECTED));
        } else {
            this.writer.emitField(prop.getOptionalPropertyType(optional).getGenericType(), valueFieldName, EnumSet.of(Modifier.PROTECTED), optional.absent());
        }
        if (interfaceType != null && hasBuilderProperties) {
            this.writer.emitField(prop.getParameterizedBuilderInterfaceType(interfaceType, optional).getGenericType(), prop.getBuilderFieldName(), EnumSet.of(Modifier.PROTECTED));
        }
    }

    private void emitButMethod(TypeM selfType) throws IOException {
        String builderTypeStr = this.writer.compressType(selfType.getGenericType());
        this.writer.emitEmptyLine().emitJavadoc("Returns a clone of this builder.\n\n@return the clone", new Object[0]);
        if (selfType.isGeneric()) {
            this.writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral((String)"unchecked"));
        }
        this.writer.emitAnnotation(GwtIncompatible.class).beginMethod(builderTypeStr, "but", EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("return (%s)clone()", new Object[]{builderTypeStr}).endMethod();
    }

    private void emitCloneMethod(TypeM selfType, CloneMethodM cloneMethod) throws IOException {
        String builderTypeStr = this.writer.compressType(selfType.getGenericType());
        this.writer.emitEmptyLine().emitJavadoc("Returns a clone of this builder.\n\n@return the clone", new Object[0]).emitAnnotation(Override.class).emitAnnotation(GwtIncompatible.class).beginMethod("Object", "clone", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (cloneMethod.shouldCatchCloneNotSupportedException()) {
            this.writer.beginControlFlow("try", new Object[0]);
        }
        if (selfType.isGeneric()) {
            this.writer.emitAnnotation(SuppressWarnings.class, (Object)JavaWriter.stringLiteral((String)"unchecked"));
        }
        this.writer.emitStatement("%s result = (%s)super.clone()", new Object[]{builderTypeStr, builderTypeStr}).emitStatement("result.self = result", new Object[0]).emitStatement("return result", new Object[0]);
        if (cloneMethod.shouldCatchCloneNotSupportedException()) {
            this.writer.nextControlFlow("catch (CloneNotSupportedException e)", new Object[0]).emitStatement("throw new InternalError(e.getMessage())", new Object[0]).endControlFlow();
        }
        this.writer.endMethod();
    }
}

