/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.karneim.pojobuilder.model.TypeM;

public class ImportTypesM {
    private final Set<TypeM> types = new HashSet<TypeM>();
    private final Set<String> simpleNames = new HashSet<String>();

    public void add(Class<?> aClass) {
        this.add(new TypeM(aClass));
    }

    public boolean add(TypeM e) {
        if (this.simpleNames.contains(e.getSimpleName())) {
            return false;
        }
        this.simpleNames.add(e.getSimpleName());
        return this.types.add(e);
    }

    public boolean canAdd(TypeM typeM) {
        return !this.types.contains(typeM) && !this.simpleNames.contains(typeM.getSimpleName());
    }

    public List<String> getSortedDistinctClassnames() {
        HashSet<String> resultSet = new HashSet<String>();
        for (TypeM t : this.types) {
            if (t.isTypeVariable() || t.isPrimitive()) continue;
            resultSet.add(t.getName());
        }
        ArrayList<String> result = new ArrayList<String>(resultSet);
        Collections.sort(result);
        return result;
    }

    public void removePackage(String packageName) {
        Iterator<TypeM> it = this.types.iterator();
        while (it.hasNext()) {
            TypeM t = it.next();
            if (!t.isInPackage(packageName)) continue;
            it.remove();
        }
    }
}

