/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.Iterator;
import java.util.List;
import net.karneim.pojobuilder.analysis.PropertyPattern;
import net.karneim.pojobuilder.model.BuildMethodM;
import net.karneim.pojobuilder.model.ConstructorParameterM;
import net.karneim.pojobuilder.model.FactoryMethodParameterM;
import net.karneim.pojobuilder.model.FieldAccessM;
import net.karneim.pojobuilder.model.MethodM;
import net.karneim.pojobuilder.model.OptionalM;
import net.karneim.pojobuilder.model.PrimitiveTypeM;
import net.karneim.pojobuilder.model.SetterMethodM;
import net.karneim.pojobuilder.model.TypeM;
import net.karneim.pojobuilder.model.TypeWildcardM;
import net.karneim.pojobuilder.model.WriteAccess;

public class PropertyM {
    private TypeM propertyType;
    private String propertyName;
    private String withMethodName;
    private ConstructorParameterM writableViaConstructorParameter;
    private SetterMethodM writableViaSetterMethod;
    private MethodM readableViaGetterMethod;
    private FactoryMethodParameterM writableViaFactoryMethodParameter;
    private FieldAccessM fieldAccess;

    public PropertyM(String propertyName, TypeM propertyType) {
        this.propertyType = propertyType;
        this.propertyName = propertyName;
    }

    public TypeM getPropertyType() {
        return this.propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isField() {
        return this.isAccessibleViaFieldAccess();
    }

    public String getWithMethodName() {
        return this.withMethodName;
    }

    public PropertyM withMethodNamePattern(String methodNamePattern) {
        this.withMethodName = methodNamePattern.startsWith("*") ? methodNamePattern.replace("*", this.propertyName) : methodNamePattern.replace("*", this.fcUpperCase(this.propertyName));
        return this;
    }

    private String fcUpperCase(String text) {
        if (text == null) {
            return null;
        }
        return text.substring(0, 1).toUpperCase().concat(text.substring(1));
    }

    public boolean isOptionalProperty(OptionalM optional) {
        return this.propertyType.getName().equals(optional.getType().getName());
    }

    public TypeM getBasicPropertyType(OptionalM optional) {
        if (optional == null || !this.isOptionalProperty(optional)) {
            return this.propertyType;
        }
        Iterator typeParameters = this.propertyType.getTypeParameters().iterator();
        if (typeParameters.hasNext()) {
            return (TypeM)typeParameters.next();
        }
        System.out.println("Property is of an optional type without type parameters: " + this);
        return new TypeM(Object.class);
    }

    public TypeM getParameterizedBuilderInterfaceType(TypeM interfaceType, OptionalM optional) {
        TypeM basicType = this.getBasicPropertyType(optional);
        TypeM typeParam = basicType.isPrimitive() ? ((PrimitiveTypeM)basicType).getBoxType() : basicType;
        return new TypeM(interfaceType.getPackageName(), interfaceType.getSimpleName()).withTypeParameter(new TypeWildcardM().whichExtends(typeParam));
    }

    public TypeM getOptionalPropertyType(OptionalM optional) {
        if (this.isOptionalProperty(optional)) {
            return this.propertyType;
        }
        TypeM typeParam = this.propertyType.isPrimitive() ? ((PrimitiveTypeM)this.propertyType).getBoxType() : this.propertyType;
        TypeM optionalType = optional.getType();
        TypeM result = new TypeM(optionalType.getPackageName(), optionalType.getSimpleName()).withTypeParameter(new TypeWildcardM().whichExtends(typeParam));
        return result;
    }

    public ConstructorParameterM getConstructorParameter() {
        return this.writableViaConstructorParameter;
    }

    public PropertyM writableVia(ConstructorParameterM constructorParameter) {
        this.writableViaConstructorParameter = constructorParameter;
        return this;
    }

    public boolean isWritableViaConstructor() {
        return this.getConstructorParameter() != null;
    }

    public PropertyM writableVia(SetterMethodM setterMethod) {
        this.writableViaSetterMethod = setterMethod;
        return this;
    }

    public SetterMethodM getSetterMethod() {
        return this.writableViaSetterMethod;
    }

    public boolean isWritableViaSetterMethod() {
        return this.writableViaSetterMethod != null;
    }

    public PropertyM readableVia(MethodM getterMethod) {
        this.readableViaGetterMethod = getterMethod;
        return this;
    }

    public MethodM getGetterMethod() {
        return this.readableViaGetterMethod;
    }

    public boolean isReadableViaGetterMethod() {
        return this.readableViaGetterMethod != null;
    }

    public PropertyM accessibleVia(FieldAccessM fieldAccess) {
        this.fieldAccess = fieldAccess;
        return this;
    }

    public FieldAccessM getFieldAccess() {
        return this.fieldAccess;
    }

    public boolean isAccessibleViaFieldAccess() {
        return this.fieldAccess != null;
    }

    public FactoryMethodParameterM getFactoryMethodParameter() {
        return this.writableViaFactoryMethodParameter;
    }

    public PropertyM writableVia(FactoryMethodParameterM param) {
        this.writableViaFactoryMethodParameter = param;
        return this;
    }

    public boolean isWritableViaFactoryMethod() {
        return this.writableViaFactoryMethodParameter != null;
    }

    public boolean isWritableViaSetterMethodBy(TypeM accessingClass) {
        return this.isWritableViaSetterMethod() && this.getSetterMethod().isAccessibleFor(accessingClass);
    }

    public boolean isWritableViaFieldAccessBy(TypeM accessingClass) {
        return this.isAccessibleViaFieldAccess() && this.getFieldAccess().isWritableFor(accessingClass);
    }

    public boolean isWritableBy(TypeM accessingClass) {
        return this.isWritableViaFieldAccessBy(accessingClass) || this.isWritableViaSetterMethodBy(accessingClass) || this.isWritableViaConstructor() || this.isWritableViaFactoryMethod();
    }

    public boolean isReadableViaGetterMethodBy(TypeM accessingClass) {
        return this.isReadableViaGetterMethod() && this.getGetterMethod().isAccessibleFor(accessingClass);
    }

    public boolean isReadableViaFieldAccessBy(TypeM accessingClass) {
        return this.isAccessibleViaFieldAccess() && this.getFieldAccess().isReadableFor(accessingClass);
    }

    public String getValueFieldName() {
        String typeIdentifier = this.getTypeIdentifierForFieldName();
        return String.format("value$%s$%s", this.getPropertyName(), typeIdentifier);
    }

    public String getIsSetFieldName() {
        String typeIdentifier = this.getTypeIdentifierForFieldName();
        return String.format("isSet$%s$%s", this.getPropertyName(), typeIdentifier);
    }

    public String getBuilderFieldName() {
        String typeIdentifier = this.getTypeIdentifierForFieldName();
        return String.format("builder$%s$%s", this.getPropertyName(), typeIdentifier);
    }

    public String getCallTo(BuildMethodM buildMethod) {
        return this.getBuilderFieldName() + "." + buildMethod.getName() + "()";
    }

    private String getTypeIdentifierForFieldName() {
        return this.getPropertyType().getName().replaceAll("\\.", "\\$").replaceAll("\\[\\]", "\\$L");
    }

    public WriteAccess getPreferredWriteAccessFor(TypeM accessingClass) {
        if (this.isWritableViaConstructor()) {
            return this.getConstructorParameter();
        }
        if (this.isWritableViaFactoryMethod()) {
            return this.getFactoryMethodParameter();
        }
        if (this.isWritableViaSetterMethodBy(accessingClass)) {
            return this.getSetterMethod();
        }
        if (this.isWritableViaFieldAccessBy(accessingClass)) {
            return this.getFieldAccess();
        }
        return null;
    }

    public boolean matchesAnyOf(List<PropertyPattern> list) {
        for (PropertyPattern pattern : list) {
            if (!this.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(PropertyPattern pattern) {
        return pattern.contains(this);
    }

    public String toString() {
        return "PropertyM [propertyType=" + this.propertyType + ", propertyName=" + this.propertyName + ", withMethodName=" + this.withMethodName + ", writableViaConstructorParameter=" + this.writableViaConstructorParameter + ", writableViaSetterMethod=" + this.writableViaSetterMethod + ", readableViaGetterMethod=" + this.readableViaGetterMethod + ", writableViaFactoryMethodParameter=" + this.writableViaFactoryMethodParameter + ", fieldAccess=" + this.fieldAccess + "]";
    }
}

