/*
 * Decompiled with CFR 0.152.
 */
package net.karneim.pojobuilder.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.karneim.pojobuilder.model.ImportTypesM;
import net.karneim.pojobuilder.model.TypeM;

public class TypeListM
extends ArrayList<TypeM> {
    public TypeListM(TypeM ... types) {
        this((Iterable<TypeM>)Arrays.asList(types));
    }

    public TypeListM(Iterable<TypeM> types) {
        for (TypeM type : types) {
            this.add(type);
        }
    }

    public String toParameterString() {
        StringBuilder result = new StringBuilder();
        for (TypeM type : this) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(type.getGenericTypeDefinition());
        }
        return result.toString();
    }

    public String toArgumentString() {
        StringBuilder result = new StringBuilder();
        for (TypeM type : this) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(type.getGenericType());
        }
        return result.toString();
    }

    public void add(Class<?> aClass) {
        this.add(new TypeM(aClass));
    }

    public ImportTypesM addToImportTypes(ImportTypesM result) {
        for (TypeM t : this) {
            t.addToImportTypes(result);
        }
        return result;
    }

    public TypeM[] asArray() {
        return this.toArray(new TypeM[this.size()]);
    }

    public TypeListM collectDistinctTypeVariablesRecursevly(TypeListM result) {
        for (TypeM type : this) {
            if (type.isTypeVariable()) {
                if (result.contains(type)) continue;
                result.add(type);
                continue;
            }
            type.getTypeParameters().collectDistinctTypeVariablesRecursevly(result);
        }
        return result;
    }
}

