/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.quality;

import java.util.ArrayList;
import java.util.List;
import net.kemitix.quality.QualityRunner;
import net.kemitix.quality.api.PluginGoal;
import net.kemitix.quality.goals.checkstyle.CheckstyleConfiguration;
import net.kemitix.quality.goals.digraph.DigraphConfiguration;
import net.kemitix.quality.goals.enforcer.EnforcerConfiguration;
import net.kemitix.quality.goals.highwheel.HighwheelConfiguration;
import net.kemitix.quality.goals.huntbugs.HuntbugsConfiguration;
import net.kemitix.quality.goals.jacoco.JacocoConfiguration;
import net.kemitix.quality.goals.pitest.PitestConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractCheckMojo
extends AbstractMojo
implements DigraphConfiguration,
CheckstyleConfiguration,
EnforcerConfiguration,
HuntbugsConfiguration,
JacocoConfiguration,
HighwheelConfiguration,
PitestConfiguration {
    @Component(role=QualityRunner.class)
    private QualityRunner qualityRunner;
    @Parameter(property="digraphVersion", defaultValue="0.9.0", readonly=true)
    private String digraphVersion;
    @Parameter(property="digraphBasePackage", required=true, readonly=true)
    private String digraphBasePackage;
    @Parameter(property="digraphIncludeTests", defaultValue="false", readonly=true)
    private boolean digraphIncludeTests;
    @Parameter(property="digraphDebug", defaultValue="false", readonly=true)
    private boolean digraphDebug;
    @Parameter(property="checkstylePluginVersion", defaultValue="2.17", readonly=true)
    private String checkstylePluginVersion;
    @Parameter(property="checkstyleVersion", defaultValue="8.0", readonly=true)
    private String checkstyleVersion;
    @Parameter(property="sevntuVersion", defaultValue="1.24.1", readonly=true)
    private String sevntuVersion;
    @Parameter(property="rulesetVersion", defaultValue="3.3.0", readonly=true)
    private String rulesetVersion;
    @Parameter(property="rulesetLevel", defaultValue="5-complexity", readonly=true)
    private String rulesetLevel;
    @Parameter(property="enforcerVersion", defaultValue="1.4.1", readonly=true)
    private String enforcerVersion;
    @Parameter(property="requiredMavenVersion", defaultValue="3.3.9", readonly=true)
    private String requiredMavenVersion;
    @Parameter(property="requiredJavaVersion", defaultValue="1.8", readonly=true)
    private String requiredJavaVersion;
    @Parameter(property="huntbugsVersion", defaultValue="0.0.11", readonly=true)
    private String huntbugsVersion;
    @Parameter(property="jacocoVersion", defaultValue="0.7.9", readonly=true)
    private String jacocoVersion;
    @Parameter(property="jacocoCoverage", defaultValue="1", readonly=true)
    private String jacocoCoverage;
    @Parameter(property="jacocoMissedClasses", defaultValue="0", readonly=true)
    private String jacocoMissedClasses;
    @Parameter(property="highwheelVersion", defaultValue="1.2", readonly=true)
    private String highwheelVersion;
    @Parameter(property="pitestVersion", defaultValue="1.2.2", readonly=true)
    private String pitestVersion;
    @Parameter(property="pitestMutation", defaultValue="100", readonly=true)
    private String pitestMutation;
    @Parameter(property="pitestCoverage", defaultValue="100", readonly=true)
    private String pitestCoverage;
    @Parameter(property="qualityDisabled", readonly=true)
    private final List<String> qualityDisabled = new ArrayList<String>();

    protected abstract PluginGoal.LifecyclePhase getLifecyclePhase();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.qualityRunner.setCheckMojo(this);
        this.qualityRunner.setLifecyclePhase(this.getLifecyclePhase());
        this.qualityRunner.run();
    }

    public void setQualityRunner(QualityRunner qualityRunner) {
        this.qualityRunner = qualityRunner;
    }

    public String getDigraphVersion() {
        return this.digraphVersion;
    }

    public String getDigraphBasePackage() {
        return this.digraphBasePackage;
    }

    public boolean isDigraphIncludeTests() {
        return this.digraphIncludeTests;
    }

    public boolean isDigraphDebug() {
        return this.digraphDebug;
    }

    public String getCheckstylePluginVersion() {
        return this.checkstylePluginVersion;
    }

    public String getCheckstyleVersion() {
        return this.checkstyleVersion;
    }

    public String getSevntuVersion() {
        return this.sevntuVersion;
    }

    public String getRulesetVersion() {
        return this.rulesetVersion;
    }

    public String getRulesetLevel() {
        return this.rulesetLevel;
    }

    public String getEnforcerVersion() {
        return this.enforcerVersion;
    }

    public String getRequiredMavenVersion() {
        return this.requiredMavenVersion;
    }

    public String getRequiredJavaVersion() {
        return this.requiredJavaVersion;
    }

    public String getHuntbugsVersion() {
        return this.huntbugsVersion;
    }

    public String getJacocoVersion() {
        return this.jacocoVersion;
    }

    public String getJacocoCoverage() {
        return this.jacocoCoverage;
    }

    public String getJacocoMissedClasses() {
        return this.jacocoMissedClasses;
    }

    public String getHighwheelVersion() {
        return this.highwheelVersion;
    }

    public String getPitestVersion() {
        return this.pitestVersion;
    }

    public String getPitestMutation() {
        return this.pitestMutation;
    }

    public String getPitestCoverage() {
        return this.pitestCoverage;
    }

    public List<String> getQualityDisabled() {
        return this.qualityDisabled;
    }
}

