/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.quality;

import javax.inject.Inject;
import javax.inject.Named;
import net.kemitix.quality.PluginExecutor;
import net.kemitix.quality.QualityPluginException;
import net.kemitix.quality.api.PluginGoal;
import net.kemitix.quality.mojoexecutor.MojoExecutorWrapper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
final class PluginExecutorImpl
implements PluginExecutor {
    private final MojoExecutorWrapper mojoExecutorWrapper;
    private final MavenSession mavenSession;
    private final BuildPluginManager pluginManager;

    @Inject
    PluginExecutorImpl(MojoExecutorWrapper mojoExecutorWrapper, MavenSession mavenSession, BuildPluginManager pluginManager) {
        this.mojoExecutorWrapper = mojoExecutorWrapper;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
    }

    @Override
    public void execute(PluginGoal pluginGoal, Log log) {
        pluginGoal.getGoals().forEach(goal -> this.executeGoal(pluginGoal, log, (String)goal));
    }

    private void executeGoal(PluginGoal pluginGoal, Log log, String goal) {
        Plugin plugin = pluginGoal.getPlugin();
        log.info((CharSequence)String.format("-- %s:%s:%s --", plugin.getArtifactId(), plugin.getVersion(), goal));
        pluginGoal.onExecute(goal);
        try {
            this.mojoExecutorWrapper.executeMojo(plugin, goal, (Xpp3Dom)plugin.getConfiguration(), this.mavenSession, this.pluginManager);
            pluginGoal.onSuccess(goal);
        }
        catch (MojoExecutionException e) {
            pluginGoal.onError(goal, e);
            throw new QualityPluginException(goal, e);
        }
        finally {
            pluginGoal.onComplete(goal);
        }
    }
}

