/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.quality;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import net.kemitix.quality.AbstractCheckMojo;
import net.kemitix.quality.PluginExecutor;
import net.kemitix.quality.QualityRunner;
import net.kemitix.quality.api.PluginGoal;
import net.kemitix.quality.api.PluginGoalConfiguration;

@Named
class QualityRunnerImpl
implements QualityRunner {
    private final PluginExecutor pluginExecutor;
    private final List<PluginGoal> pluginGoals;
    private AbstractCheckMojo checkMojo;
    private PluginGoal.LifecyclePhase lifecyclePhase;

    @Inject
    QualityRunnerImpl(PluginExecutor pluginExecutor, List<PluginGoal> pluginGoals) {
        this.pluginExecutor = pluginExecutor;
        this.pluginGoals = pluginGoals;
    }

    @Override
    public void run() {
        this.pluginGoals.stream().filter(this.matchesLifecyclePhase()).filter(this.isNotDisabled()).sorted(Comparator.comparing(PluginGoal::getWeight)).forEach(this::executePluginGoal);
    }

    private Predicate<PluginGoal> matchesLifecyclePhase() {
        return pluginGoal -> pluginGoal.matches(this.lifecyclePhase);
    }

    private Predicate<PluginGoal> isNotDisabled() {
        return this.isDisabled().negate();
    }

    private Predicate<PluginGoal> isDisabled() {
        return pluginGoal -> this.checkMojo.getQualityDisabled().contains(pluginGoal.getName());
    }

    private void executePluginGoal(PluginGoal pluginGoal) {
        pluginGoal.configuration((PluginGoalConfiguration)this.checkMojo);
        this.pluginExecutor.execute(pluginGoal, this.checkMojo.getLog());
    }

    @Override
    public void setCheckMojo(AbstractCheckMojo checkMojo) {
        this.checkMojo = checkMojo;
    }

    @Override
    public void setLifecyclePhase(PluginGoal.LifecyclePhase lifecyclePhase) {
        this.lifecyclePhase = lifecyclePhase;
    }
}

