/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.util.function.Consumer;
import java.util.stream.IntStream;

class ByteBufferSegment {
    private final byte[] buf;
    private final int off;
    private final int len;

    public void forEach(Consumer<Byte> byteConsumer) {
        if (this.len < 0 || this.buf.length < this.off + this.len) {
            throw new IndexOutOfBoundsException(String.format("buf.length: %d, off: %d, len: %d", this.buf.length, this.off, this.len));
        }
        IntStream.range(this.off, this.off + this.len).map(i -> this.buf[i]).forEach((int b) -> byteConsumer.accept((byte)b));
    }

    public ByteBufferSegment(byte[] buf, int off, int len) {
        this.buf = buf;
        this.off = off;
        this.len = len;
    }
}

