/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.io.PrintStream;
import java.util.function.Predicate;
import lombok.NonNull;
import net.kemitix.wrapper.printstream.ByteBufferSegment;
import net.kemitix.wrapper.printstream.PassthroughPrintStreamWrapper;

class ByteFilterPrintStreamWrapper
extends PassthroughPrintStreamWrapper {
    private final Predicate<Byte> predicate;

    ByteFilterPrintStreamWrapper(PrintStream original, @NonNull Predicate<Byte> predicate) {
        super(original);
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        this.predicate = predicate;
    }

    @Override
    public final void write(int b) {
        if (this.predicate.test((byte)b)) {
            super.write(b);
        }
    }

    @Override
    public final void write(byte[] buf, int off, int len) {
        new ByteBufferSegment(buf, off, len).forEach(this::write);
    }
}

