/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.io.PrintStream;
import java.util.function.Function;
import lombok.NonNull;
import net.kemitix.wrapper.printstream.ByteBufferSegment;
import net.kemitix.wrapper.printstream.PassthroughPrintStreamWrapper;

class ByteTransformPrintStreamWrapper
extends PassthroughPrintStreamWrapper {
    private final Function<Byte, Byte> transformer;

    ByteTransformPrintStreamWrapper(PrintStream original, @NonNull Function<Byte, Byte> transformer) {
        super(original);
        if (transformer == null) {
            throw new NullPointerException("transformer");
        }
        this.transformer = transformer;
    }

    @Override
    public final void write(int b) {
        this.printStreamDelegate().write(this.transformer.apply((byte)b).byteValue());
    }

    @Override
    public final void write(byte[] buf, int off, int len) {
        new ByteBufferSegment(buf, off, len).forEach(this::write);
    }
}

