/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.io.PrintStream;
import java.util.Optional;
import lombok.NonNull;
import net.kemitix.wrapper.Wrapper;
import net.kemitix.wrapper.printstream.PrintStreamWrapper;
import net.kemitix.wrapper.printstream.SubjectPrintStreamWrapper;

class PassthroughPrintStreamWrapper
extends PrintStream
implements PrintStreamWrapper {
    private final PrintStreamWrapper wrapper;

    PassthroughPrintStreamWrapper(PrintStream original) {
        super(original);
        this.wrapper = this.wrap(original);
    }

    private PrintStreamWrapper wrap(PrintStream original) {
        return new SubjectPrintStreamWrapper(original);
    }

    @Override
    public void write(int b) {
        this.wrapper.write(b);
    }

    @Override
    public void write(@NonNull byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        this.wrapper.write(buf, off, len);
    }

    public PrintStream getWrapperSubject() {
        return (PrintStream)this.wrapper.getWrapperSubject();
    }

    public final Optional<Wrapper<PrintStream>> getInnerWrapper() {
        return Optional.of(this.wrapper);
    }
}

