/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.wrapper.printstream;

import java.io.PrintStream;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kemitix.wrapper.Wrapper;
import net.kemitix.wrapper.printstream.ByteFilterPrintStreamWrapper;
import net.kemitix.wrapper.printstream.ByteTransformPrintStreamWrapper;
import net.kemitix.wrapper.printstream.CopyPrintStreamWrapper;
import net.kemitix.wrapper.printstream.StringFilterPrintStreamWrapper;
import net.kemitix.wrapper.printstream.StringTransformPrintStreamWrapper;

public interface PrintStreamWrapper
extends Wrapper<PrintStream> {
    public static PrintStream filter(PrintStream printStream, StringFilter filter) {
        return new StringFilterPrintStreamWrapper(printStream, filter);
    }

    public static PrintStream filter(PrintStream printStream, ByteFilter filter) {
        return new ByteFilterPrintStreamWrapper(printStream, filter);
    }

    public static Optional<Wrapper<PrintStream>> unwrap(PrintStream printStream) {
        if (printStream instanceof PrintStreamWrapper) {
            return ((Wrapper)printStream).getInnerWrapper();
        }
        return Optional.empty();
    }

    public static PrintStream copy(PrintStream left, PrintStream right) {
        return new CopyPrintStreamWrapper(left, right);
    }

    public static PrintStream transform(PrintStream original, StringTransform transformer) {
        return new StringTransformPrintStreamWrapper(original, transformer);
    }

    public static PrintStream transform(PrintStream original, ByteTransform transformer) {
        return new ByteTransformPrintStreamWrapper(original, transformer);
    }

    default public PrintStream printStreamDelegate() {
        return (PrintStream)this.getWrapperSubject();
    }

    public void write(int var1);

    public void write(byte[] var1, int var2, int var3);

    @FunctionalInterface
    public static interface ByteTransform
    extends Function<Byte, Byte> {
    }

    @FunctionalInterface
    public static interface StringTransform
    extends Function<String, String> {
    }

    @FunctionalInterface
    public static interface ByteFilter
    extends Predicate<Byte> {
    }

    @FunctionalInterface
    public static interface StringFilter
    extends Predicate<String> {
    }
}

