/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.analysisComponent.AbstractAnalysisComponent;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.model.analysisMetaModel.MIDependency;
import kieker.analysis.model.analysisMetaModel.MIFilter;
import kieker.analysis.model.analysisMetaModel.MIInputPort;
import kieker.analysis.model.analysisMetaModel.MIOutputPort;
import kieker.analysis.model.analysisMetaModel.MIPlugin;
import kieker.analysis.model.analysisMetaModel.MIProject;
import kieker.analysis.model.analysisMetaModel.MIProperty;
import kieker.analysis.model.analysisMetaModel.MIRepository;
import kieker.analysis.model.analysisMetaModel.MIRepositoryConnector;
import kieker.analysis.model.analysisMetaModel.impl.MAnalysisMetaModelFactory;
import kieker.analysis.model.analysisMetaModel.impl.MAnalysisMetaModelPackage;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.IPlugin;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.configuration.Configuration;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public final class MetaModelHandler {
    private MetaModelHandler() {
    }

    public static final void saveProjectToFile(File file, MIProject project) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        resource.getContents().add((Object)project);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }

    public static final MIProject loadProjectFromFile(File file) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MAnalysisMetaModelPackage.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                XMIResourceImpl resource = (XMIResourceImpl)super.createResource(uri);
                resource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                return resource;
            }
        });
        XMIResource resource = (XMIResource)resourceSet.getResource(URI.createFileURI((String)file.toString()), true);
        resource.load(Collections.EMPTY_MAP);
        EList content = resource.getContents();
        if (!content.isEmpty()) {
            return (MIProject)content.get(0);
        }
        throw new IOException("No object found in file '" + file.getAbsolutePath() + "'.");
    }

    public static final Configuration modelPropertiesToConfiguration(EList<MIProperty> mProperties) {
        Configuration configuration = new Configuration();
        for (MIProperty mProperty : mProperties) {
            configuration.setProperty(mProperty.getName(), mProperty.getValue());
        }
        return configuration;
    }

    public static void checkPorts(MIPlugin mPlugin, AbstractPlugin plugin) throws AnalysisConfigurationException {
        EList<MIOutputPort> mOutputPorts = mPlugin.getOutputPorts();
        HashSet<String> outputPorts = new HashSet<String>();
        for (String outputPort : plugin.getAllOutputPortNames()) {
            outputPorts.add(outputPort);
        }
        HashSet<String> inputPorts = new HashSet<String>();
        for (String inputPort : plugin.getAllInputPortNames()) {
            inputPorts.add(inputPort);
        }
        for (MIOutputPort mOutputPort : mOutputPorts) {
            if (outputPorts.contains(mOutputPort.getName())) continue;
            throw new AnalysisConfigurationException("The output port '" + mOutputPort.getName() + "' of '" + mPlugin.getName() + "' (" + mPlugin.getClassname() + ") does not exist.");
        }
        BasicEList mInputPorts = mPlugin instanceof MIFilter ? ((MIFilter)mPlugin).getInputPorts() : new BasicEList();
        for (MIInputPort mInputPort : mInputPorts) {
            if (inputPorts.contains(mInputPort.getName())) continue;
            throw new AnalysisConfigurationException("The input port '" + mInputPort.getName() + "' of '" + mPlugin.getName() + "' (" + mPlugin.getClassname() + ") does not exist.");
        }
    }

    public static List<MIProperty> convertProperties(Configuration configuration, MAnalysisMetaModelFactory factory) {
        if (null == configuration) {
            return Collections.emptyList();
        }
        ArrayList<MIProperty> properties = new ArrayList<MIProperty>(configuration.size());
        Enumeration<?> e = configuration.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            MIProperty property = factory.createProperty();
            property.setName(key);
            property.setValue(configuration.getStringProperty(key));
            properties.add(property);
        }
        return properties;
    }

    public static final MIInputPort findInputPort(MIFilter mPlugin, String name) {
        for (MIInputPort port : mPlugin.getInputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public static final MIOutputPort findOutputPort(MIPlugin mPlugin, String name) {
        for (MIOutputPort port : mPlugin.getOutputPorts()) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public static final MIProject javaToMetaModel(Collection<AbstractReaderPlugin> readers, Collection<AbstractFilterPlugin> filters, Collection<AbstractRepository> repositories, Collection<MIDependency> dependencies, String projectName, Configuration globalConfiguration) throws AnalysisConfigurationException {
        try {
            MAnalysisMetaModelFactory factory = new MAnalysisMetaModelFactory();
            MIProject mProject = factory.createProject();
            mProject.setName(projectName);
            mProject.getDependencies().addAll(dependencies);
            HashMap<AbstractPlugin, MIPlugin> pluginMap = new HashMap<AbstractPlugin, MIPlugin>();
            HashMap<AbstractRepository, MIRepository> repositoryMap = new HashMap<AbstractRepository, MIRepository>();
            for (AbstractRepository abstractRepository : repositories) {
                MIRepository mIRepository = factory.createRepository();
                mIRepository.setId(EcoreUtil.generateUUID());
                mIRepository.setClassname(abstractRepository.getClass().getName());
                mIRepository.getProperties().addAll(MetaModelHandler.convertProperties(abstractRepository.getCurrentConfiguration(), factory));
                mProject.getRepositories().add((Object)mIRepository);
                repositoryMap.put(abstractRepository, mIRepository);
            }
            ArrayList<AbstractReaderPlugin> plugins = new ArrayList<AbstractReaderPlugin>(readers);
            plugins.addAll(filters);
            for (AbstractPlugin abstractPlugin : plugins) {
                String[] stringArray;
                String[] outs;
                MIPlugin mPlugin = abstractPlugin instanceof AbstractReaderPlugin ? factory.createReader() : factory.createFilter();
                mPlugin.setId(EcoreUtil.generateUUID());
                mPlugin.setClassname(abstractPlugin.getClass().getName());
                mPlugin.setName(abstractPlugin.getName());
                mPlugin.getProperties().addAll(MetaModelHandler.convertProperties(abstractPlugin.getCurrentConfiguration(), factory));
                for (Map.Entry<String, AbstractRepository> entry : abstractPlugin.getCurrentRepositories().entrySet()) {
                    AbstractRepository repository = entry.getValue();
                    MIRepository mRepository = (MIRepository)repositoryMap.get(repository);
                    if (mRepository == null) {
                        throw new AnalysisConfigurationException("Repository '" + repository.getName() + "' (" + repository.getRepositoryName() + ") not contained in project. Maybe the repository has not been registered.");
                    }
                    MIRepositoryConnector mRepositoryConn = factory.createRepositoryConnector();
                    mRepositoryConn.setId(EcoreUtil.generateUUID());
                    mRepositoryConn.setName(entry.getKey());
                    mRepositoryConn.setRepository(mRepository);
                    mPlugin.getRepositories().add((Object)mRepositoryConn);
                }
                for (String out : outs = abstractPlugin.getAllOutputPortNames()) {
                    MIOutputPort mOutputPort = factory.createOutputPort();
                    mOutputPort.setId(EcoreUtil.generateUUID());
                    mOutputPort.setName(out);
                    mPlugin.getOutputPorts().add((Object)mOutputPort);
                }
                for (String in : stringArray = abstractPlugin.getAllInputPortNames()) {
                    MIInputPort mInputPort = factory.createInputPort();
                    mInputPort.setId(EcoreUtil.generateUUID());
                    mInputPort.setName(in);
                    ((MIFilter)mPlugin).getInputPorts().add((Object)mInputPort);
                }
                mProject.getPlugins().add((Object)mPlugin);
                pluginMap.put(abstractPlugin, mPlugin);
            }
            for (IPlugin iPlugin : plugins) {
                MIPlugin mOutputPlugin = (MIPlugin)pluginMap.get(iPlugin);
                for (String outputPortName : iPlugin.getAllOutputPortNames()) {
                    EList<MIInputPort> subscribers = MetaModelHandler.findOutputPort(mOutputPlugin, outputPortName).getSubscribers();
                    for (IPlugin.PluginInputPortReference subscriber : iPlugin.getConnectedPlugins(outputPortName)) {
                        IPlugin subscriberPlugin = subscriber.getPlugin();
                        MIPlugin mSubscriberPlugin = (MIPlugin)pluginMap.get(subscriberPlugin);
                        if (mSubscriberPlugin == null) {
                            throw new AnalysisConfigurationException("Plugin '" + subscriberPlugin.getName() + "' (" + subscriberPlugin.getPluginName() + ") not contained in project. Maybe the plugin has not been registered.");
                        }
                        MIInputPort mInputPort = MetaModelHandler.findInputPort((MIFilter)mSubscriberPlugin, subscriber.getInputPortName());
                        subscribers.add((Object)mInputPort);
                    }
                }
            }
            Set<Map.Entry<Object, Object>> set = globalConfiguration.entrySet();
            for (Map.Entry<Object, Object> property : set) {
                MIProperty mProperty = factory.createProperty();
                mProperty.setName((String)property.getKey());
                mProperty.setValue((String)property.getValue());
                mProject.getProperties().add((Object)mProperty);
            }
            return mProject;
        }
        catch (Exception ex) {
            throw new AnalysisConfigurationException("Failed to retrieve current configuration of AnalysisCopntroller.", ex);
        }
    }

    public static final void metaModelToJava(MIProject mProject, AnalysisController ac, Collection<PluginConnection> pluginConnections, Collection<RepositoryConnection> repositoryConnections, Collection<MIDependency> dependencies, ClassLoader classLoader, Configuration globalConfiguration, Map<MIRepository, AbstractRepository> repositoryMap, Map<MIPlugin, AbstractPlugin> pluginMap) throws AnalysisConfigurationException {
        MAnalysisMetaModelFactory factory = new MAnalysisMetaModelFactory();
        for (MIDependency mDepdendency : mProject.getDependencies()) {
            MIDependency mDepdendencyCopy = factory.createDependency();
            mDepdendencyCopy.setFilePath(mDepdendency.getFilePath());
            dependencies.add(mDepdendencyCopy);
        }
        for (MIRepository mRepository : mProject.getRepositories()) {
            Configuration configuration = MetaModelHandler.modelPropertiesToConfiguration(mRepository.getProperties());
            AbstractRepository repository = MetaModelHandler.createAndInitialize(AbstractRepository.class, mRepository.getClassname(), configuration, ac, classLoader);
            repositoryMap.put(mRepository, repository);
        }
        EList<MIPlugin> mPlugins = mProject.getPlugins();
        for (MIPlugin mPlugin : mPlugins) {
            Configuration configuration = MetaModelHandler.modelPropertiesToConfiguration(mPlugin.getProperties());
            String pluginClassname = mPlugin.getClassname();
            configuration.setProperty("name-hiddenAndNeverExportedProperty", mPlugin.getName());
            AbstractPlugin plugin = MetaModelHandler.createAndInitialize(AbstractPlugin.class, pluginClassname, configuration, ac, classLoader);
            pluginMap.put(mPlugin, plugin);
            MetaModelHandler.checkConfiguration(plugin, configuration);
        }
        for (MIPlugin mPlugin : mPlugins) {
            MetaModelHandler.checkPorts(mPlugin, pluginMap.get(mPlugin));
            EList<MIRepositoryConnector> mPluginRPorts = mPlugin.getRepositories();
            for (MIRepositoryConnector mPluginRPort : mPluginRPorts) {
                repositoryConnections.add(new RepositoryConnection(pluginMap.get(mPlugin), repositoryMap.get(mPluginRPort.getRepository()), mPluginRPort.getName()));
            }
            EList<MIOutputPort> mPluginOPorts = mPlugin.getOutputPorts();
            for (MIOutputPort mPluginOPort : mPluginOPorts) {
                String outputPortName = mPluginOPort.getName();
                AbstractPlugin srcPlugin = pluginMap.get(mPlugin);
                EList<MIInputPort> mSubscribers = mPluginOPort.getSubscribers();
                for (MIInputPort mSubscriber : mSubscribers) {
                    String inputPortName = mSubscriber.getName();
                    AbstractPlugin dstPlugin = pluginMap.get(mSubscriber.getParent());
                    pluginConnections.add(new PluginConnection(srcPlugin, dstPlugin, outputPortName, inputPortName));
                }
            }
        }
        for (MIProperty mProperty : mProject.getProperties()) {
            globalConfiguration.setProperty(mProperty.getName(), mProperty.getValue());
        }
    }

    private static final <C extends AbstractAnalysisComponent> C createAndInitialize(Class<C> c, String classname, Configuration configuration, IProjectContext projectContext, ClassLoader classLoader) throws AnalysisConfigurationException {
        try {
            Class<?> clazz = Class.forName(classname, true, classLoader);
            if (c.isAssignableFrom(clazz)) {
                return (C)((AbstractAnalysisComponent)clazz.getConstructor(Configuration.class, IProjectContext.class).newInstance(configuration, projectContext));
            }
            throw new AnalysisConfigurationException("Class '" + classname + "' has to implement or extend '" + c.getSimpleName() + "'");
        }
        catch (ClassNotFoundException ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Class '" + classname + "' not found", ex);
        }
        catch (NoSuchMethodException ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Class '" + classname + "' has to implement a (public) constructor that accepts a single Configuration", ex);
        }
        catch (Exception ex) {
            throw new AnalysisConfigurationException(c.getSimpleName() + ": Failed to load class for name '" + classname + "'", ex);
        }
    }

    private static void checkConfiguration(AbstractPlugin plugin, Configuration configuration) throws AnalysisConfigurationException {
        HashSet<String> possibleKeys = new HashSet<String>();
        Object e = plugin.getCurrentConfiguration().propertyNames();
        while (e.hasMoreElements()) {
            possibleKeys.add((String)e.nextElement());
        }
        for (Property property : MetaModelHandler.extractAnnotatedProperties(plugin)) {
            possibleKeys.add(property.name());
        }
        e = configuration.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (possibleKeys.contains(key) || key.equals("name-hiddenAndNeverExportedProperty")) continue;
            throw new AnalysisConfigurationException("Invalid property of '" + plugin.getName() + "' (" + plugin.getPluginName() + ") found: '" + key + "'.");
        }
    }

    private static Property[] extractAnnotatedProperties(AbstractPlugin plugin) {
        Plugin pluginAnnotation = plugin.getClass().getAnnotation(Plugin.class);
        if (pluginAnnotation != null) {
            return pluginAnnotation.configuration();
        }
        return new Property[0];
    }

    public static class PluginConnection {
        private final AbstractPlugin source;
        private final AbstractPlugin destination;
        private final String outputName;
        private final String inputName;

        public PluginConnection(AbstractPlugin source, AbstractPlugin destination, String outputName, String inputName) {
            this.source = source;
            this.destination = destination;
            this.outputName = outputName;
            this.inputName = inputName;
        }

        public AbstractPlugin getSource() {
            return this.source;
        }

        public AbstractPlugin getDestination() {
            return this.destination;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public String getInputName() {
            return this.inputName;
        }
    }

    public static class RepositoryConnection {
        private final AbstractPlugin source;
        private final AbstractRepository repository;
        private final String outputName;

        public RepositoryConnection(AbstractPlugin source, AbstractRepository repository, String outputName) {
            this.source = source;
            this.repository = repository;
            this.outputName = outputName;
        }

        public AbstractPlugin getSource() {
            return this.source;
        }

        public AbstractRepository getRepository() {
            return this.repository;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

