/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;

@Plugin(description="A filter to print the object to a configured stream", outputPorts={@OutputPort(name="relayedEvents", description="Provides each incoming object", eventTypes={Object.class})}, configuration={@Property(name="stream", defaultValue="STDOUT", description="The name of the stream used to print the incoming data (special values are STDOUT, STDERR, STDlog, and NULL; other values are interpreted as filenames)."), @Property(name="characterEncoding", defaultValue="UTF-8", description="The used encoding for the selected stream."), @Property(name="append", defaultValue="true", description="Decides whether the filter appends to the stream in the case of a file or not.")})
public final class TeeFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "receivedEvents";
    public static final String OUTPUT_PORT_NAME_RELAYED_EVENTS = "relayedEvents";
    public static final String CONFIG_PROPERTY_NAME_STREAM = "stream";
    public static final String CONFIG_PROPERTY_NAME_ENCODING = "characterEncoding";
    public static final String CONFIG_PROPERTY_NAME_APPEND = "append";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDOUT = "STDOUT";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDERR = "STDERR";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_STDLOG = "STDlog";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_NULL = "NULL";
    public static final String CONFIG_PROPERTY_VALUE_DEFAULT_ENCODING = "UTF-8";
    public static final String CONFIG_PROPERTY_VALUE_STREAM_APPEND = "true";
    private final PrintStream printStream;
    private final String printStreamName;
    private final boolean active;
    private final boolean append;
    private final String encoding;

    public TeeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        String printStreamNameConfig = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_STREAM);
        this.encoding = this.configuration.getStringProperty(CONFIG_PROPERTY_NAME_ENCODING);
        if (CONFIG_PROPERTY_VALUE_STREAM_STDLOG.equals(printStreamNameConfig)) {
            this.printStream = null;
            this.printStreamName = null;
            this.active = true;
            this.append = false;
        } else if (CONFIG_PROPERTY_VALUE_STREAM_STDOUT.equals(printStreamNameConfig)) {
            this.printStream = System.out;
            this.printStreamName = null;
            this.active = true;
            this.append = false;
        } else if (CONFIG_PROPERTY_VALUE_STREAM_STDERR.equals(printStreamNameConfig)) {
            this.printStream = System.err;
            this.printStreamName = null;
            this.active = true;
            this.append = false;
        } else if (CONFIG_PROPERTY_VALUE_STREAM_NULL.equals(printStreamNameConfig)) {
            this.printStream = null;
            this.printStreamName = null;
            this.active = false;
            this.append = false;
        } else {
            PrintStream tmpPrintStream;
            this.append = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_APPEND);
            try {
                tmpPrintStream = new PrintStream((OutputStream)new FileOutputStream(printStreamNameConfig, this.append), false, this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error("Failed to initialize {}", (Object)printStreamNameConfig, (Object)ex);
                tmpPrintStream = null;
            }
            catch (FileNotFoundException ex) {
                this.logger.error("Failed to initialize {}", (Object)printStreamNameConfig, (Object)ex);
                tmpPrintStream = null;
            }
            this.printStream = tmpPrintStream;
            this.printStreamName = printStreamNameConfig;
            this.active = true;
        }
    }

    @Override
    public final void terminate(boolean error) {
        if (this.printStream != null && this.printStream != System.out && this.printStream != System.err) {
            this.printStream.close();
        }
    }

    @Override
    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_ENCODING, this.encoding);
        configuration.setProperty(CONFIG_PROPERTY_NAME_APPEND, Boolean.toString(this.append));
        if (this.printStream == null) {
            if (this.active) {
                configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDLOG);
            } else {
                configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_NULL);
            }
        } else if (this.printStream == System.out) {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDOUT);
        } else if (this.printStream == System.err) {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, CONFIG_PROPERTY_VALUE_STREAM_STDERR);
        } else {
            configuration.setProperty(CONFIG_PROPERTY_NAME_STREAM, this.printStreamName);
        }
        return configuration;
    }

    @InputPort(name="receivedEvents", description="Receives incoming objects to be logged and forwarded", eventTypes={Object.class})
    public final void inputEvent(Object object) {
        if (this.active) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(this.getName()).append('(').append(object.getClass().getSimpleName()).append(") ").append(object.toString());
            String record = sb.toString();
            if (this.printStream != null) {
                this.printStream.println(record);
            } else {
                this.logger.info(record);
            }
        }
        super.deliver(OUTPUT_PORT_NAME_RELAYED_EVENTS, object);
    }
}

