/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.sink;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.display.PieChart;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.system.MemSwapUsageRecord;

@Plugin(configuration={@Property(name="numberOfEntries", defaultValue="100", description="Sets the number of max plot entries per record entry")})
public class MemSwapUtilizationDisplayFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EVENTS = "inputEvents";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES = "numberOfEntries";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_OF_ENTRIES = "100";
    private static final String MEM_FREE = "memFree";
    private static final String MEM_TOTAL = "memTotal";
    private static final String MEM_USED = "memUsed";
    private static final String SWAP_FREE = "swapFree";
    private static final String SWAP_TOTAL = "swapTotal";
    private static final String SWAP_USED = "swapUsed";
    private final XYPlot xyplot;
    private final PieChart memPieChart;
    private final PieChart swapPieChart;
    private final int numberOfEntries;

    public MemSwapUtilizationDisplayFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.numberOfEntries = configuration.getIntProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES);
        this.xyplot = new XYPlot(this.numberOfEntries);
        this.memPieChart = new PieChart();
        this.swapPieChart = new PieChart();
    }

    @InputPort(name="inputEvents", eventTypes={MemSwapUsageRecord.class})
    public void input(MemSwapUsageRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(MemSwapUsageRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnitFromProjectContext));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname();
        this.xyplot.setEntry(id + " - " + MEM_FREE, minutesAndSeconds, record.getMemFree() / 0x100000L);
        this.xyplot.setEntry(id + " - " + MEM_TOTAL, minutesAndSeconds, record.getMemTotal() / 0x100000L);
        this.xyplot.setEntry(id + " - " + MEM_USED, minutesAndSeconds, record.getMemUsed() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_FREE, minutesAndSeconds, record.getSwapFree() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_TOTAL, minutesAndSeconds, record.getSwapTotal() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_USED, minutesAndSeconds, record.getSwapUsed() / 0x100000L);
        this.memPieChart.setValue(id + " - " + MEM_FREE, record.getMemFree());
        this.memPieChart.setValue(id + " - " + MEM_USED, record.getMemUsed());
        this.swapPieChart.setValue(id + " - " + SWAP_FREE, record.getSwapFree());
        this.swapPieChart.setValue(id + " - " + SWAP_USED, record.getSwapUsed());
    }

    @Display(name="XYPlot Memory utilization Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }

    @Display(name="PieChart Memory Utilization Display")
    public PieChart getMemPieChart() {
        return this.memPieChart;
    }

    @Display(name="PieChart Swap Utilization Display")
    public PieChart getSwapPieChart() {
        return this.swapPieChart;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_OF_ENTRIES, String.valueOf(this.numberOfEntries));
        return configuration;
    }
}

