/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kieker.analysis.plugin.reader.AbstractStringRegistryReaderPlugin;
import kieker.analysis.plugin.reader.StringRegistryCache;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.BinaryValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegularRecordHandler
implements Runnable {
    private static final int DEFAULT_QUEUE_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegularRecordHandler.class);
    private final StringRegistryCache stringRegistryCache;
    private final CachedRecordFactoryCatalog cachedRecordFactoryCatalog = CachedRecordFactoryCatalog.getInstance();
    private final AbstractStringRegistryReaderPlugin reader;
    private final BlockingQueue<ByteBuffer> queue = new ArrayBlockingQueue<ByteBuffer>(4096);

    public RegularRecordHandler(AbstractStringRegistryReaderPlugin reader, StringRegistryCache stringRegistryCache) {
        this.reader = reader;
        this.stringRegistryCache = stringRegistryCache;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ByteBuffer nextRecord = this.queue.take();
                    this.readRegularRecord(nextRecord);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Regular record handler was interrupted", e);
                continue;
            }
            break;
        }
    }

    public void enqueueRegularRecord(ByteBuffer buffer) {
        try {
            this.queue.put(buffer);
        }
        catch (InterruptedException e) {
            LOGGER.error("Record queue was interrupted", e);
        }
    }

    private ReaderRegistry<String> getStringRegistry(long registryId) {
        return this.stringRegistryCache.getOrCreateRegistry(registryId);
    }

    private void readRegularRecord(ByteBuffer buffer) {
        long registryId = buffer.getLong();
        int classId = buffer.getInt();
        long loggingTimestamp = buffer.getLong();
        ReaderRegistry<String> stringRegistry = this.getStringRegistry(registryId);
        try {
            String recordClassName = stringRegistry.get(classId);
            IRecordFactory<? extends IMonitoringRecord> recordFactory = this.cachedRecordFactoryCatalog.get(recordClassName);
            IMonitoringRecord record = recordFactory.create(BinaryValueDeserializer.create(buffer, stringRegistry));
            record.setLoggingTimestamp(loggingTimestamp);
            this.reader.deliverRecord(record);
        }
        catch (RecordInstantiationException e) {
            LOGGER.error("Error instantiating record", e);
        }
    }
}

