/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kieker.common.registry.reader.ReaderRegistry;

public class StringRegistryCache {
    private final Cache<Long, ReaderRegistry<String>> cache;

    public StringRegistryCache(long expirationDuration, TimeUnit expirationTimeUnit) {
        this.cache = this.createCache(expirationDuration, expirationTimeUnit);
    }

    protected Cache<Long, ReaderRegistry<String>> createCache(long expirationDuration, TimeUnit expirationTimeUnit) {
        return CacheBuilder.newBuilder().expireAfterAccess(expirationDuration, expirationTimeUnit).build();
    }

    public ReaderRegistry<String> getOrCreateRegistry(Long registryId) {
        try {
            return (ReaderRegistry)this.cache.get((Object)registryId, (Callable)new RegistryLoader());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class RegistryLoader
    implements Callable<ReaderRegistry<String>> {
        @Override
        public ReaderRegistry<String> call() throws Exception {
            return new ReaderRegistry<String>();
        }
    }
}

