/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.depcompression;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.common.configuration.Configuration;

public class GZipDecompressionFilter
extends AbstractDecompressionFilter {
    public static final String PREFIX = GZipDecompressionFilter.class.getCanonicalName();
    public static final String BUFFER_SIZE = PREFIX + "bufferSize";
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int bufferSize;

    public GZipDecompressionFilter(Configuration configuration) {
        super(configuration);
        this.bufferSize = configuration.getIntProperty(BUFFER_SIZE, 0x100000);
    }

    @Override
    public InputStream chainInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(inputStream), this.bufferSize);
    }

    @Override
    public String getExtension() {
        return ".gz";
    }
}

