/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.depcompression;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.common.configuration.Configuration;
import org.tukaani.xz.XZInputStream;

public class XZDecompressionFilter
extends AbstractDecompressionFilter {
    public static final String PREFIX = XZDecompressionFilter.class.getCanonicalName();
    public static final String BUFFER_SIZE = PREFIX + "bufferSize";
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final int bufferSize;

    public XZDecompressionFilter(Configuration configuration) {
        super(configuration);
        this.bufferSize = configuration.getIntProperty(BUFFER_SIZE, 0x100000);
    }

    @Override
    public InputStream chainInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream((InputStream)new XZInputStream(inputStream, this.bufferSize));
    }

    @Override
    public String getExtension() {
        return ".xz";
    }
}

