/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.filesystem.AbstractLogReaderThread;
import kieker.analysis.plugin.reader.filesystem.AsciiLogReaderThread;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.EmptyRecord;

@Plugin(description="A file system reader which reads records from multiple directories", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the reader")}, configuration={@Property(name="inputDirs", defaultValue=".", description="The name of the input dirs used to read data (multiple dirs are separated by |)."), @Property(name="ignoreUnknownRecordTypes", defaultValue="false", description="Ignore unknown records? Aborts if encountered and value is false.")})
public class AsciiLogReader
extends AbstractReaderPlugin
implements IMonitoringRecordReceiver {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_INPUTDIRS = "inputDirs";
    public static final String CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES = "ignoreUnknownRecordTypes";
    public static final String CONFIG_SHOULD_DECOMPRESS = "shouldDecompress";
    private static final IMonitoringRecord EOF = new EmptyRecord();
    private final boolean ignoreUnknownRecordTypes;
    private final boolean shouldDecompress;
    private final String[] inputDirs;
    private final PriorityQueue<IMonitoringRecord> recordQueue;
    private final List<AbstractLogReaderThread> readerThreads = new ArrayList<AbstractLogReaderThread>();

    public AsciiLogReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.inputDirs = this.configuration.getStringArrayProperty(CONFIG_PROPERTY_NAME_INPUTDIRS);
        int nDirs = this.inputDirs.length;
        for (int i = 0; i < nDirs; ++i) {
            if (".".equals(this.inputDirs[i])) continue;
            this.inputDirs[i] = Configuration.convertToPath(this.inputDirs[i]);
        }
        if (nDirs == 0) {
            this.logger.warn("The list of input dirs passed to the {} is empty", (Object)AsciiLogReader.class.getSimpleName());
            nDirs = 1;
        }
        this.recordQueue = new PriorityQueue(nDirs);
        this.ignoreUnknownRecordTypes = this.configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES);
        this.shouldDecompress = this.configuration.getBooleanProperty(CONFIG_SHOULD_DECOMPRESS);
    }

    @Override
    public void terminate(boolean error) {
        this.logger.info("Shutting down reader.");
        for (AbstractLogReaderThread readerThread : this.readerThreads) {
            readerThread.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public boolean read() {
        int notInitializesReaders = 0;
        for (String inputDirFn : this.inputDirs) {
            File inputDir = new File(inputDirFn);
            if (inputDir.isDirectory()) {
                AsciiLogReaderThread readerThread = new AsciiLogReaderThread(inputDir, this, this.ignoreUnknownRecordTypes, this.shouldDecompress);
                this.readerThreads.add(readerThread);
                readerThread.start();
                continue;
            }
            this.logger.warn("Invalid Directory or filename (no Kieker log): {}", (Object)inputDirFn);
            ++notInitializesReaders;
        }
        int readingReaders = this.inputDirs.length - notInitializesReaders;
        while (readingReaders > 0) {
            IMonitoringRecord record;
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                while (this.recordQueue.size() < readingReaders) {
                    try {
                        this.recordQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            IMonitoringRecord iMonitoringRecord = record = (IMonitoringRecord)this.recordQueue.remove();
            synchronized (iMonitoringRecord) {
                record.notifyAll();
            }
            if (record == EOF) {
                --readingReaders;
                continue;
            }
            super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"})
    public boolean newMonitoringRecord(IMonitoringRecord record) {
        IMonitoringRecord iMonitoringRecord = record;
        synchronized (iMonitoringRecord) {
            PriorityQueue<IMonitoringRecord> priorityQueue = this.recordQueue;
            synchronized (priorityQueue) {
                this.recordQueue.add(record);
                this.recordQueue.notifyAll();
            }
            try {
                record.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_INPUTDIRS, Configuration.toProperty(this.inputDirs));
        configuration.setProperty(CONFIG_PROPERTY_NAME_IGNORE_UNKNOWN_RECORD_TYPES, Boolean.toString(this.ignoreUnknownRecordTypes));
        return configuration;
    }

    @Override
    public void newEndOfFileRecord() {
        this.newMonitoringRecord(EOF);
    }
}

