/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink.display;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.display.PieChart;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.common.record.system.MemSwapUsageRecord;
import teetime.framework.AbstractConsumerStage;

public class MemSwapUtilizationDisplayFilter
extends AbstractConsumerStage<MemSwapUsageRecord> {
    public static final String MEM_FREE = "memFree";
    public static final String MEM_TOTAL = "memTotal";
    public static final String MEM_USED = "memUsed";
    public static final String SWAP_FREE = "swapFree";
    public static final String SWAP_TOTAL = "swapTotal";
    public static final String SWAP_USED = "swapUsed";
    private final XYPlot xyplot;
    private final PieChart memPieChart;
    private final PieChart swapPieChart;
    private final TimeUnit recordsTimeUnit;

    public MemSwapUtilizationDisplayFilter(int numberOfEntries, TimeUnit recordsTimeUnit) {
        this.recordsTimeUnit = recordsTimeUnit;
        this.xyplot = new XYPlot(numberOfEntries);
        this.memPieChart = new PieChart();
        this.swapPieChart = new PieChart();
    }

    protected void execute(MemSwapUsageRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(MemSwapUsageRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnit));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname();
        this.xyplot.setEntry(id + " - " + MEM_FREE, minutesAndSeconds, record.getMemFree() / 0x100000L);
        this.xyplot.setEntry(id + " - " + MEM_TOTAL, minutesAndSeconds, record.getMemTotal() / 0x100000L);
        this.xyplot.setEntry(id + " - " + MEM_USED, minutesAndSeconds, record.getMemUsed() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_FREE, minutesAndSeconds, record.getSwapFree() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_TOTAL, minutesAndSeconds, record.getSwapTotal() / 0x100000L);
        this.xyplot.setEntry(id + " - " + SWAP_USED, minutesAndSeconds, record.getSwapUsed() / 0x100000L);
        this.memPieChart.setValue(id + " - " + MEM_FREE, record.getMemFree());
        this.memPieChart.setValue(id + " - " + MEM_USED, record.getMemUsed());
        this.swapPieChart.setValue(id + " - " + SWAP_FREE, record.getSwapFree());
        this.swapPieChart.setValue(id + " - " + SWAP_USED, record.getSwapUsed());
    }

    @Display(name="XYPlot Memory utilization Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }

    @Display(name="PieChart Memory Utilization Display")
    public PieChart getMemPieChart() {
        return this.memPieChart;
    }

    @Display(name="PieChart Swap Utilization Display")
    public PieChart getSwapPieChart() {
        return this.swapPieChart;
    }
}

