/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.sink.display;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import kieker.common.record.jvm.ThreadsStatusRecord;
import teetime.framework.AbstractConsumerStage;

public class ThreadsStatusDisplayFilter
extends AbstractConsumerStage<ThreadsStatusRecord> {
    public static final String TOTAL_THREADS = "Total Threads";
    public static final String THREADS = "Threads";
    public static final String DAEMON_THREADS = "Daemon Threads";
    public static final String PEAK_THREADS = "Peak Threads";
    private final XYPlot xyplot;
    private final TimeUnit recordsTimeUnit;

    public ThreadsStatusDisplayFilter(int numberOfEntries, TimeUnit recordsTimeUnit) {
        this.recordsTimeUnit = recordsTimeUnit;
        this.xyplot = new XYPlot(numberOfEntries);
    }

    public void execute(ThreadsStatusRecord record) {
        this.updateDisplays(record);
    }

    private void updateDisplays(ThreadsStatusRecord record) {
        Date date = new Date(TimeUnit.MILLISECONDS.convert(record.getLoggingTimestamp(), this.recordsTimeUnit));
        String minutesAndSeconds = date.toString().substring(14, 19);
        String id = record.getHostname() + " - " + record.getVmName();
        this.xyplot.setEntry(id + " - " + THREADS, minutesAndSeconds, record.getThreadCount());
        this.xyplot.setEntry(id + " - " + TOTAL_THREADS, minutesAndSeconds, record.getTotalStartedThreadCount());
        this.xyplot.setEntry(id + " - " + PEAK_THREADS, minutesAndSeconds, record.getPeakThreadCount());
        this.xyplot.setEntry(id + " - " + DAEMON_THREADS, minutesAndSeconds, record.getDaemonThreadCount());
    }

    @Display(name="XYPlot Display")
    public XYPlot getXYPlot() {
        return this.xyplot;
    }
}

