/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import kieker.analysis.plugin.reader.depcompression.AbstractDecompressionFilter;
import kieker.analysis.plugin.reader.depcompression.NoneDecompressionFilter;
import kieker.analysis.plugin.reader.util.FSReaderUtil;
import kieker.analysis.source.file.AbstractEventDeserializer;
import kieker.analysis.source.file.AbstractMapDeserializer;
import kieker.analysis.source.file.MapFileFilter;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.registry.reader.ReaderRegistry;
import teetime.framework.OutputPort;
import teetime.stage.basic.AbstractTransformation;

public class DirectoryReaderStage
extends AbstractTransformation<File, IMonitoringRecord> {
    private final FilenameFilter mapFilter = new MapFileFilter();
    private final Configuration configuration;

    public DirectoryReaderStage(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void execute(File directory) {
        ReaderRegistry<String> registry = new ReaderRegistry<String>();
        File[] mapFiles = directory.listFiles(this.mapFilter);
        if (mapFiles == null) {
            this.logger.error("{} is not a proper directory.", (Object)directory.getAbsolutePath());
        } else {
            for (File mapFile : mapFiles) {
                String mapFileName = mapFile.getName();
                try {
                    this.readMapFile(new FileInputStream(mapFile), mapFileName, registry);
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Cannot find map file {}.", (Object)mapFileName);
                }
            }
            try {
                Files.list(directory.toPath()).sorted().forEach(logFilePath -> {
                    File logFile = logFilePath.toFile();
                    String logFileName = logFile.getName();
                    try {
                        this.readLogFile(new FileInputStream(logFile), logFileName, registry);
                    }
                    catch (FileNotFoundException e) {
                        this.logger.error("Cannot find log file {}.", (Object)logFileName);
                    }
                });
            }
            catch (IOException e1) {
                this.logger.error("Cannot process directory {}", (Object)directory.getAbsolutePath());
            }
        }
    }

    private void readMapFile(InputStream inputStream, String mapFileName, ReaderRegistry<String> registry) {
        Class<? extends AbstractMapDeserializer> deserializerClass;
        Class<? extends AbstractDecompressionFilter> decompressionClass = FSReaderUtil.findDecompressionFilterByExtension(mapFileName);
        this.logger.debug("Reading map file {}", (Object)mapFileName);
        if (decompressionClass.equals(NoneDecompressionFilter.class)) {
            deserializerClass = FSReaderUtil.findMapDeserializer(mapFileName);
        } else {
            String baseName = mapFileName.substring(0, mapFileName.lastIndexOf(46) - 1);
            deserializerClass = FSReaderUtil.findMapDeserializer(baseName);
        }
        try {
            AbstractDecompressionFilter decompressionFilter = decompressionClass.getConstructor(Configuration.class).newInstance(this.configuration);
            AbstractMapDeserializer deserializer = deserializerClass.getConstructor(Configuration.class).newInstance(this.configuration);
            deserializer.processDataStream(decompressionFilter.chainInputStream(inputStream), registry, mapFileName);
        }
        catch (IOException ex) {
            this.logger.error("Reading map file {} failed.", (Object)mapFileName);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("Cannot instantiate filter {} for decompression.", (Object)decompressionClass.getName());
        }
    }

    private void readLogFile(InputStream inputStream, String logFileName, ReaderRegistry<String> registry) {
        Class<? extends AbstractEventDeserializer> deserializerClass;
        Class<? extends AbstractDecompressionFilter> decompressionClass = FSReaderUtil.findDecompressionFilterByExtension(logFileName);
        this.logger.debug("Reading log file {}", (Object)logFileName);
        if (decompressionClass.equals(NoneDecompressionFilter.class)) {
            deserializerClass = FSReaderUtil.findEventDeserializer(logFileName);
        } else {
            String baseName = logFileName.substring(0, logFileName.lastIndexOf(46));
            deserializerClass = FSReaderUtil.findEventDeserializer(baseName);
        }
        if (deserializerClass != null) {
            try {
                AbstractDecompressionFilter decompressionFilter = decompressionClass.getConstructor(Configuration.class).newInstance(this.configuration);
                AbstractEventDeserializer deserializer = deserializerClass.getConstructor(Configuration.class, ReaderRegistry.class).newInstance(this.configuration, registry);
                deserializer.processDataStream(decompressionFilter.chainInputStream(inputStream), (OutputPort<IMonitoringRecord>)this.outputPort);
            }
            catch (IOException e) {
                this.logger.error("Reading log file {} failed.", (Object)logFileName);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.logger.error("Cannot instantiate filter {} for decompression.", (Object)decompressionClass.getName());
            }
        } else {
            this.logger.debug("Skipping file {}, as the extension indicates that it is not a log file.", (Object)logFileName);
        }
    }
}

