/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.source.file;

import java.io.File;
import java.io.FilenameFilter;
import kieker.analysis.source.file.MapFileFilter;
import teetime.framework.AbstractProducerStage;

public class DirectoryScannerStage
extends AbstractProducerStage<File> {
    private final File[] directories;
    private final FilenameFilter filter = new MapFileFilter();
    private int numOfDirectories;

    public DirectoryScannerStage(File[] directories) {
        this.directories = directories;
    }

    protected void execute() {
        if (this.directories != null) {
            for (File directory : this.directories) {
                this.logger.debug("Scanning directories in {} for Kieker logs", (Object)directory);
                if (!directory.isDirectory()) continue;
                this.scanDirectory(directory);
            }
        } else {
            this.logger.error("Cannot process an empty array of directories.");
        }
        this.logger.debug("Processed {} directories.", (Object)this.numOfDirectories);
        this.workCompleted();
    }

    private void scanDirectory(File directory) {
        if (this.isKiekerDirectory(directory)) {
            this.logger.debug("Reading log data from {}", (Object)directory.getAbsolutePath());
            ++this.numOfDirectories;
            this.getOutputPort().send((Object)directory);
        } else {
            for (File subDirectory : directory.listFiles()) {
                if (!subDirectory.isDirectory()) continue;
                this.scanDirectory(subDirectory);
            }
        }
    }

    private boolean isKiekerDirectory(File directory) {
        return directory.isDirectory() && directory.exists() && directory.listFiles(this.filter).length > 0;
    }
}

