/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime;

import java.io.File;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import kieker.analysisteetime.OperationCallExtractorStage;
import kieker.analysisteetime.dependencygraphs.DependencyGraphCreatorStage;
import kieker.analysisteetime.dependencygraphs.DeploymentLevelOperationDependencyGraphBuilderFactory;
import kieker.analysisteetime.dependencygraphs.dot.DotExportConfigurationFactory;
import kieker.analysisteetime.dependencygraphs.vertextypes.IVertexTypeMapper;
import kieker.analysisteetime.model.ExecutionModelAssemblerStage;
import kieker.analysisteetime.model.ModelObjectFromOperationCallAccessors;
import kieker.analysisteetime.model.StaticModelsAssemblerStage;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyFactory;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyModel;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentFactory;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentModel;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionFactory;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionModel;
import kieker.analysisteetime.model.analysismodel.trace.OperationCall;
import kieker.analysisteetime.model.analysismodel.type.TypeFactory;
import kieker.analysisteetime.model.analysismodel.type.TypeModel;
import kieker.analysisteetime.recordreading.AllowedRecordsFilter;
import kieker.analysisteetime.recordreading.ReadingComposite;
import kieker.analysisteetime.signature.NameBuilder;
import kieker.analysisteetime.signature.SignatureExtractor;
import kieker.analysisteetime.statistics.CallStatisticsStage;
import kieker.analysisteetime.statistics.FullReponseTimeStatisticsStage;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.trace.graph.TraceToGraphTransformerStage;
import kieker.analysisteetime.trace.graph.dot.DotTraceGraphFileWriterStage;
import kieker.analysisteetime.trace.reconstruction.TraceReconstructorStage;
import kieker.analysisteetime.trace.reconstruction.TraceStatisticsDecoratorStage;
import kieker.analysisteetime.util.graph.export.dot.DotExportConfiguration;
import kieker.analysisteetime.util.graph.export.dot.DotFileWriterStage;
import kieker.analysisteetime.util.stage.trigger.TriggerOnTerminationStage;
import teetime.framework.Configuration;
import teetime.stage.basic.distributor.Distributor;
import teetime.stage.basic.distributor.strategy.CopyByReferenceStrategy;
import teetime.stage.basic.distributor.strategy.IDistributorStrategy;

public class ExampleConfiguration
extends Configuration {
    private final TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
    private final AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
    private final DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
    private final ExecutionModel executionModel = ExecutionFactory.eINSTANCE.createExecutionModel();
    private final StatisticsModel statisticsModel = new StatisticsModel();
    private final SignatureExtractor signatureExtractor = SignatureExtractor.forJava();

    public ExampleConfiguration(File importDirectory, File exportDirectory) {
        ChronoUnit timeUnitOfRecods = ChronoUnit.NANOS;
        Function<OperationCall, Object> statisticsObjectAccesor = ModelObjectFromOperationCallAccessors.DEPLOYED_OPERATION;
        DeploymentLevelOperationDependencyGraphBuilderFactory deploymentGraphBuilderFactory = new DeploymentLevelOperationDependencyGraphBuilderFactory();
        DotExportConfiguration dependencyGraphDotExportConfiguration = new DotExportConfigurationFactory(NameBuilder.forJavaShortOperations(), IVertexTypeMapper.TO_STRING).createForDeploymentLevelOperationDependencyGraph();
        ReadingComposite reader = new ReadingComposite(importDirectory);
        AllowedRecordsFilter allowedRecordsFilter = new AllowedRecordsFilter();
        StaticModelsAssemblerStage staticModelsAssembler = new StaticModelsAssemblerStage(this.typeModel, this.assemblyModel, this.deploymentModel, this.signatureExtractor);
        TraceReconstructorStage traceReconstructor = new TraceReconstructorStage(this.deploymentModel, timeUnitOfRecods);
        TraceStatisticsDecoratorStage traceStatisticsDecorator = new TraceStatisticsDecoratorStage();
        OperationCallExtractorStage operationCallExtractor = new OperationCallExtractorStage();
        ExecutionModelAssemblerStage executionModelAssembler = new ExecutionModelAssemblerStage(this.executionModel);
        FullReponseTimeStatisticsStage fullStatisticsDecorator = new FullReponseTimeStatisticsStage(this.statisticsModel, statisticsObjectAccesor);
        CallStatisticsStage callStatisticsDecorator = new CallStatisticsStage(this.statisticsModel, this.executionModel);
        TraceToGraphTransformerStage traceToGraphTransformer = new TraceToGraphTransformerStage();
        DotTraceGraphFileWriterStage dotTraceGraphFileWriter = DotTraceGraphFileWriterStage.create(exportDirectory);
        Distributor traceDistributor = new Distributor((IDistributorStrategy)new CopyByReferenceStrategy());
        TriggerOnTerminationStage onTerminationTrigger = new TriggerOnTerminationStage();
        DependencyGraphCreatorStage dependencyGraphCreator = new DependencyGraphCreatorStage(this.executionModel, this.statisticsModel, deploymentGraphBuilderFactory);
        DotFileWriterStage dotDepGraphFileWriter = new DotFileWriterStage(exportDirectory.getPath(), dependencyGraphDotExportConfiguration);
        super.connectPorts(reader.getOutputPort(), allowedRecordsFilter.getInputPort());
        super.connectPorts(allowedRecordsFilter.getOutputPort(), staticModelsAssembler.getInputPort());
        super.connectPorts(staticModelsAssembler.getOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), traceStatisticsDecorator.getInputPort());
        super.connectPorts(traceStatisticsDecorator.getOutputPort(), traceDistributor.getInputPort());
        super.connectPorts(traceDistributor.getNewOutputPort(), traceToGraphTransformer.getInputPort());
        super.connectPorts(traceToGraphTransformer.getOutputPort(), dotTraceGraphFileWriter.getInputPort());
        super.connectPorts(traceDistributor.getNewOutputPort(), operationCallExtractor.getInputPort());
        super.connectPorts(operationCallExtractor.getOutputPort(), executionModelAssembler.getInputPort());
        super.connectPorts(executionModelAssembler.getOutputPort(), fullStatisticsDecorator.getInputPort());
        super.connectPorts(fullStatisticsDecorator.getOutputPort(), callStatisticsDecorator.getInputPort());
        super.connectPorts(callStatisticsDecorator.getOutputPort(), onTerminationTrigger.getInputPort());
        super.connectPorts(onTerminationTrigger.getOutputPort(), dependencyGraphCreator.getInputPort());
        super.connectPorts(dependencyGraphCreator.getOutputPort(), dotDepGraphFileWriter.getInputPort());
    }

    public DeploymentModel getDeploymentModel() {
        return this.deploymentModel;
    }

    public ExecutionModel getExecutionModel() {
        return this.executionModel;
    }

    public StatisticsModel getStatisticsModel() {
        return this.statisticsModel;
    }
}

