/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.dependencygraphs;

import java.time.temporal.ChronoUnit;
import kieker.analysisteetime.dependencygraphs.IDependencyGraphBuilder;
import kieker.analysisteetime.dependencygraphs.ResponseTimeDecorator;
import kieker.analysisteetime.dependencygraphs.vertextypes.VertexType;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.execution.AggregatedInvocation;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionModel;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.statistics.Units;
import kieker.analysisteetime.util.ComposedKey;
import kieker.analysisteetime.util.ObjectIdentifierRegistry;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;

public abstract class AbstractDependencyGraphBuilder
implements IDependencyGraphBuilder {
    private static final Object ENTRY_VERTEX_IDENTIFIER = "entry";
    protected final IGraph graph = IGraph.create();
    protected final ObjectIdentifierRegistry identifierRegistry = new ObjectIdentifierRegistry();
    protected final ResponseTimeDecorator responseTimeDecorator;
    protected final ExecutionModel executionModel;
    protected final StatisticsModel statisticsModel;

    public AbstractDependencyGraphBuilder(ExecutionModel executionModel, StatisticsModel statisticsModel) {
        this.responseTimeDecorator = new ResponseTimeDecorator(statisticsModel, ChronoUnit.NANOS);
        this.executionModel = executionModel;
        this.statisticsModel = statisticsModel;
    }

    @Override
    public IGraph build() {
        for (AggregatedInvocation invocation : this.executionModel.getAggregatedInvocations().values()) {
            this.handleInvocation(invocation);
        }
        return this.graph;
    }

    private void handleInvocation(AggregatedInvocation invocation) {
        IVertex sourceVertex = invocation.getSource() != null ? this.addVertex(invocation.getSource()) : this.addVertexForEntry();
        IVertex targetVertex = this.addVertex(invocation.getTarget());
        long calls = this.statisticsModel.get(invocation).getStatistic(Units.RESPONSE_TIME).getProperty(Properties.COUNT);
        this.addEdge(sourceVertex, targetVertex, calls);
    }

    protected abstract IVertex addVertex(DeployedOperation var1);

    protected IVertex addVertexForEntry() {
        int id = this.identifierRegistry.getIdentifier(ENTRY_VERTEX_IDENTIFIER);
        IVertex vertex = this.graph.addVertexIfAbsent(id);
        vertex.setPropertyIfAbsent("type", (Object)VertexType.ENTRY);
        vertex.setProperty("name", ENTRY_VERTEX_IDENTIFIER);
        return vertex;
    }

    private IEdge addEdge(IVertex source, IVertex target, long calls) {
        int edgeId = this.identifierRegistry.getIdentifier(ComposedKey.of(source, target));
        IEdge edge = source.addEdgeIfAbsent(edgeId, target);
        edge.setPropertyIfAbsent("calls", calls);
        return edge;
    }
}

