/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.dependencygraphs;

import kieker.analysisteetime.dependencygraphs.AbstractDependencyGraphBuilder;
import kieker.analysisteetime.dependencygraphs.vertextypes.VertexType;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyComponent;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyOperation;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionModel;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.util.graph.IVertex;

public class AssemblyLevelComponentDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    public AssemblyLevelComponentDependencyGraphBuilder(ExecutionModel executionModel, StatisticsModel statisticsModel) {
        super(executionModel, statisticsModel);
    }

    @Override
    protected IVertex addVertex(DeployedOperation deployedOperation) {
        AssemblyOperation operation = deployedOperation.getAssemblyOperation();
        AssemblyComponent component = operation.getAssemblyComponent();
        int componentId = this.identifierRegistry.getIdentifier(component);
        IVertex componentVertex = this.graph.addVertexIfAbsent(componentId);
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.ASSEMBLY_COMPONENT);
        componentVertex.setPropertyIfAbsent("name", component.getComponentType().getName());
        componentVertex.setPropertyIfAbsent("package name", component.getComponentType().getPackage());
        this.responseTimeDecorator.decorate(componentVertex, component);
        return componentVertex;
    }
}

